/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.quickstarts.demo.multiapp.service;

import javax.inject.Inject;
import org.switchyard.component.bean.Reference;
import org.switchyard.component.bean.Service;
import org.switchyard.quickstarts.demo.multiapp.InventoryService;
import org.switchyard.quickstarts.demo.multiapp.Item;
import org.switchyard.quickstarts.demo.multiapp.ItemNotFoundException;
import org.switchyard.quickstarts.demo.multiapp.Order;
import org.switchyard.quickstarts.demo.multiapp.OrderAck;
import org.switchyard.quickstarts.demo.multiapp.OrderService;

@Service(value=OrderService.class)
public class OrderServiceBean
implements OrderService {
    @Inject
    @Reference
    private InventoryService _inventory;

    public OrderAck submitOrder(Order order) {
        OrderAck orderAck = new OrderAck().setOrderId(order.getOrderId());
        try {
            Item orderItem = this._inventory.lookupItem(order.getItemId());
            if (orderItem.getQuantity() >= order.getQuantity()) {
                orderAck.setAccepted(true).setStatus("Order Accepted");
            } else {
                orderAck.setAccepted(false).setStatus("Insufficient Quantity");
            }
        }
        catch (ItemNotFoundException infEx) {
            orderAck.setAccepted(false).setStatus("Item Not Available");
        }
        return orderAck;
    }
}

