/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.quickstarts.camel.jpa.binding;

import java.util.Calendar;
import java.util.Random;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.switchyard.component.bean.Reference;
import org.switchyard.component.bean.Service;
import org.switchyard.quickstarts.camel.jpa.binding.PeriodicService;
import org.switchyard.quickstarts.camel.jpa.binding.StoreService;
import org.switchyard.quickstarts.camel.jpa.binding.domain.Greet;

@Service(value=PeriodicService.class)
public class PeriodicServiceImpl
implements PeriodicService {
    private static final String[] NAMES = new String[]{"Keith", "David", "Brian", "Rob", "Tomo", "Lukasz", "Magesh", "Tom"};
    private Logger _logger = LoggerFactory.getLogger(PeriodicServiceImpl.class);
    @Inject
    @Reference(value="StoreReference")
    private StoreService _store;

    @Override
    public void execute() {
        Greet greet = this.createRandomGreet();
        this._logger.info("Sending {} to JPA _store", (Object)greet);
        this._store.storeGreeting(greet);
    }

    private Greet createRandomGreet() {
        Random random = new Random(System.currentTimeMillis());
        Greet event = new Greet();
        event.setReceiver(NAMES[random.nextInt(NAMES.length)]);
        event.setSender(NAMES[random.nextInt(NAMES.length)]);
        event.setCreatedAt(Calendar.getInstance());
        return event;
    }
}

