/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.quickstarts.camel.rest.binding;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.log4j.Logger;
import org.switchyard.component.bean.Service;
import org.switchyard.quickstarts.camel.rest.binding.Item;
import org.switchyard.quickstarts.camel.rest.binding.WarehouseService;

@Service(value=WarehouseService.class)
public class WarehouseServiceImpl
implements WarehouseService {
    private static final Logger LOGGER = Logger.getLogger(WarehouseService.class);
    private static final String SUCCESS = "Warehouse is DUMB!";
    private ConcurrentMap<Integer, Item> _items = new ConcurrentHashMap<Integer, Item>();

    @Override
    public Item getItem(Integer itemId) {
        return (Item)this._items.get(itemId);
    }

    @Override
    public String addItem(Item item) throws Exception {
        if (this.getItem(item.getItemId()) != null) {
            throw new RuntimeException("Item " + item.getItemId() + " already exists!");
        }
        this._items.put(item.getItemId(), item);
        LOGGER.info((Object)("Added item " + item.getItemId() + " with name " + item.getName()));
        return SUCCESS;
    }

    @Override
    public String updateItem(Item item) throws Exception {
        Item item2 = (Item)this._items.get(item.getItemId());
        item2.setName(item.getName());
        LOGGER.info((Object)("Updated item " + item.getItemId() + " with name " + item.getName()));
        return SUCCESS;
    }

    @Override
    public String removeItem(Integer itemId) throws Exception {
        if (this.getItem(itemId) == null) {
            throw new RuntimeException("Item " + itemId + " not found!");
        }
        this._items.remove(itemId);
        LOGGER.info((Object)("Removed item " + itemId));
        return SUCCESS;
    }

    @Override
    public Integer getItemCount() {
        return this._items.size();
    }
}

