/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.quickstarts.camel.sql.binding;

import java.util.Random;
import javax.inject.Inject;
import org.switchyard.component.bean.Reference;
import org.switchyard.component.bean.Service;
import org.switchyard.quickstarts.camel.sql.binding.Greeting;
import org.switchyard.quickstarts.camel.sql.binding.GreetingService;
import org.switchyard.quickstarts.camel.sql.binding.SingleGreetService;

@Service(value=GreetingService.class)
public class GreetingServiceImpl
implements GreetingService {
    private static final String[] NAMES = new String[]{"Keith", "David", "Brian", "Rob", "Tomo", "Lukasz", "Magesh", "Tom"};
    @Inject
    @Reference(value="StoreService")
    private SingleGreetService store;
    @Inject
    @Reference(value="RemoveService")
    private SingleGreetService remove;

    @Override
    public void generate() {
        this.store(new Greeting(this.random(), this.random()));
    }

    @Override
    public void store(Greeting greeting) {
        this.store.execute(greeting);
    }

    @Override
    public void consume(Greeting[] greetings) {
        for (Greeting greeting : greetings) {
            System.out.println("Consumed [id: " + greeting.getId() + "] from " + greeting.getSender() + " to " + greeting.getReceiver());
            this.remove.execute(greeting);
        }
    }

    private String random() {
        Random random = new Random();
        return NAMES[random.nextInt(NAMES.length)];
    }
}

