# Orders Demo Quickstart

This example demonstrates how to:

1. Implement a SwitchYard Service (a simple "Orders" Service) as a set of [CDI](https://docs.jboss.org/author/display/SWITCHYARD/Bean+Services) beans.
2. Expose a SwitchYard Service through a SOAP interface.
3. Expose a [JSF](http://www.jboss.org/richfaces) User Interface to the same CDI based Service.

![Orders Quickstart](https://github.com/jboss-switchyard/quickstarts/raw/master/demos/orders/orders.jpg)


## Prerequisites

1. Java 6.
2. An unzipped SwitchYard AS7 Distribution.  <b><u>Note this example will only run on AS7</u></b>.

## Running the Example

1. Copy the Quickstart WAR file to the <i>standalone/deployments</i> directory of your unzipped SwitchYard AS7 distribution.
2. Execute the Service by creating a new Order through one of the Service interfaces:
    * <b>JSF</b>: Goto <http://localhost:8080/switchyard-quickstart-demo-orders-[switchard-version]>.
    * <b>SOAP</b>:  Using a SOAP client application (such as [soapUI](http://www.soapui.org)), load the Service WSDL (<http://localhost:18001/demo-orders/OrderService?wsdl>) and submit a new order.  Note that the only valid <i>Item ID</i> is "BUTTER".

## Further Reading

1. [SwitchYard User Documentation](https://docs.jboss.org/author/display/SWITCHYARD/)
2. [SwitchYard CDI Bean Services](https://docs.jboss.org/author/display/SWITCHYARD/Bean+Services)
3. [SwitchYard SOAP Bindings](https://docs.jboss.org/author/display/SWITCHYARD/SOAP+Bindings)
