/* 
 * JBoss, Home of Professional Open Source 
 * Copyright 2013 Red Hat Inc. and/or its affiliates and other contributors
 * as indicated by the @author tags. All rights reserved. 
 * See the copyright.txt in the distribution for a 
 * full listing of individual contributors.
 *
 * This copyrighted material is made available to anyone wishing to use, 
 * modify, copy, or redistribute it subject to the terms and conditions 
 * of the GNU Lesser General Public License, v. 2.1. 
 * This program is distributed in the hope that it will be useful, but WITHOUT A 
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A 
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details. 
 * You should have received a copy of the GNU Lesser General Public License, 
 * v.2.1 along with this distribution; if not, write to the Free Software 
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 
 * MA  02110-1301, USA.
 */

package org.switchyard.quickstarts.soap.binding.rpc;

import org.switchyard.component.bean.Service;
import org.switchyard.component.common.label.EndpointLabel;
import org.switchyard.component.soap.composer.SOAPContextMapper;

/**
 * HelloWorldService Implementation.
 */
@Service(HelloWorldService.class)
public class HelloWorldServiceBean implements HelloWorldService {

    @Override
    public String sayHello(SayHelloExternal input) {
        // TODO: Currently not possible to set property on return path for CDI Beans
        /*if (input.equals("500")) {
            context.setProperty(SOAPContextMapper.HTTP_RESPONSE_STATUS).addLabels(new String[]{EndpointLabel.HTTP.label()});
        }*/
        String greeting = "Hello World Greeting for '" + input.getToWhom() + "' in " + input.getLanguage() + " on a " + input.getDay() + "!";
        return greeting;
    }

}
