/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.quickstarts.http.binding;

import javax.inject.Inject;
import org.switchyard.Context;
import org.switchyard.Property;
import org.switchyard.Scope;
import org.switchyard.component.bean.Service;
import org.switchyard.component.http.composer.HttpRequestInfo;
import org.switchyard.quickstarts.http.binding.SymbolService;

@Service(value=SymbolService.class)
public class SymbolServiceImpl
implements SymbolService {
    @Inject
    private Context context;

    @Override
    public String getSymbol(String companyName) {
        String contentType;
        String symbol = "";
        if (companyName.equals("headers")) {
            StringBuffer headers = new StringBuffer();
            for (Property property : this.context.getProperties(Scope.IN)) {
                if (!property.hasLabel("http_header") || !(property.getValue() instanceof String)) continue;
                headers.append(property.getName());
                headers.append("=");
                headers.append(property.getValue());
            }
            return headers.toString();
        }
        if (companyName.equals("requestInfo")) {
            Property prop = this.context.getProperty("request_info", Scope.IN);
            return ((HttpRequestInfo)prop.getValue()).toString();
        }
        Property prop = this.context.getProperty("content-type", Scope.IN);
        if (prop == null) {
            prop = this.context.getProperty("Content-type", Scope.IN);
        }
        String string = contentType = prop == null ? null : (String)prop.getValue();
        if (contentType != null && contentType.contains("text/plain") && companyName.equalsIgnoreCase("vineyard")) {
            symbol = "WINE";
        }
        return symbol;
    }
}

