/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.quickstarts.soap.mtom;

import java.awt.Image;
import java.io.ByteArrayInputStream;
import java.io.StringReader;
import javax.imageio.ImageIO;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import org.switchyard.annotations.Transformer;
import org.switchyard.common.codec.Base64;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ServiceTransformers {
    private static String SOAP_RESPONSE_TEMPLATE = "<imageResponse xmlns=\"urn:switchyard-quickstart:soap-mtom:1.0\"><xop:Include xmlns:xop=\"http://www.w3.org/2004/08/xop/include\" href=\"cid:%s\"/></imageResponse>";
    private static String SOAP_EXTERNAL_REQUEST_TEMPLATE = "<ns2:image xmlns:ns2=\"urn:switchyard-quickstart:soap-mtom-external:1.0\"><xop:Include xmlns:xop=\"http://www.w3.org/2004/08/xop/include\" href=\"cid:%s\"/></ns2:image>";
    private static String SOAP_EXTERNAL_RESPONSE_TEMPLATE = "<ns2:imageResponse xmlns:ns2=\"urn:switchyard-quickstart:soap-mtom-external:1.0\"><xop:Include xmlns:xop=\"http://www.w3.org/2004/08/xop/include\" href=\"cid:%s\"/></ns2:imageResponse>";

    @Transformer(from="{urn:switchyard-quickstart:soap-mtom:1.0}image")
    public Image transformInternalRequest(Element soap) throws Exception {
        String imageString = soap.getTextContent();
        return ImageIO.read(new ByteArrayInputStream(Base64.decode((String)imageString)));
    }

    @Transformer(to="{urn:switchyard-quickstart:soap-mtom-external:1.0}image")
    public Element transformInternaltoExternalRequest(String imageName) throws Exception {
        return this.toElement(String.format(SOAP_EXTERNAL_REQUEST_TEMPLATE, imageName));
    }

    @Transformer(from="{urn:switchyard-quickstart:soap-mtom-external:1.0}image")
    public Image transformExternalRequest(Element soap) throws Exception {
        String imageString = soap.getTextContent();
        return ImageIO.read(new ByteArrayInputStream(Base64.decode((String)imageString)));
    }

    @Transformer(to="{urn:switchyard-quickstart:soap-mtom-external:1.0}imageResponse")
    public Element transformExternaltoInternalResponse(String imageName) throws Exception {
        return this.toElement(String.format(SOAP_EXTERNAL_RESPONSE_TEMPLATE, imageName));
    }

    @Transformer(from="{urn:switchyard-quickstart:soap-mtom-external:1.0}imageResponse")
    public Image transformExternalResponse(Element soap) throws Exception {
        String imageString = soap.getTextContent();
        return ImageIO.read(new ByteArrayInputStream(Base64.decode((String)imageString)));
    }

    @Transformer(to="{urn:switchyard-quickstart:soap-mtom:1.0}imageResponse")
    public Element transformInternalResponse(String imageName) throws Exception {
        return this.toElement(String.format(SOAP_RESPONSE_TEMPLATE, imageName));
    }

    private Element toElement(String xml) {
        DOMResult dom = new DOMResult();
        try {
            TransformerFactory.newInstance().newTransformer().transform(new StreamSource(new StringReader(xml)), dom);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ((Document)dom.getNode()).getDocumentElement();
    }
}

