/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.admin.base;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.switchyard.admin.Application;
import org.switchyard.admin.ComponentService;
import org.switchyard.admin.Service;
import org.switchyard.admin.Transformer;
import org.switchyard.admin.base.BaseSwitchYard;

public class BaseApplication
implements Application {
    private BaseSwitchYard _switchYard;
    private QName _name;
    private Map<QName, Service> _services;
    private Map<QName, ComponentService> _componentServices;
    private List<Transformer> _transformers;

    public BaseApplication(BaseSwitchYard switchYard, QName name, List<Service> services) {
        this(switchYard, name);
        if (services != null) {
            for (Service service : services) {
                this._services.put(service.getName(), service);
            }
        }
    }

    public BaseApplication(BaseSwitchYard switchYard, QName name) {
        this._switchYard = switchYard;
        this._name = name;
        this._services = new LinkedHashMap<QName, Service>();
        this._componentServices = new LinkedHashMap<QName, ComponentService>();
        this._transformers = new LinkedList<Transformer>();
    }

    @Override
    public QName getName() {
        return this._name;
    }

    @Override
    public List<Service> getServices() {
        if (this._services == null) {
            return Collections.emptyList();
        }
        return new ArrayList<Service>(this._services.values());
    }

    @Override
    public Service getService(QName serviceName) {
        if (this._services == null) {
            return null;
        }
        return this._services.get(serviceName);
    }

    public void setServices(List<Service> services) {
        this._services = new LinkedHashMap<QName, Service>();
        for (Service service : services) {
            this._services.put(service.getName(), service);
        }
    }

    protected void addService(Service service) {
        this._services.put(service.getName(), service);
        this._switchYard.addService(service);
    }

    protected Service removeService(QName serviceName) {
        Service service = this._services.remove(serviceName);
        if (service != null) {
            this._switchYard.removeService(service);
        }
        return service;
    }

    @Override
    public List<ComponentService> getComponentServices() {
        if (this._componentServices == null) {
            return Collections.emptyList();
        }
        return new ArrayList<ComponentService>(this._componentServices.values());
    }

    @Override
    public ComponentService getComponentService(QName componentServiceName) {
        if (this._componentServices == null) {
            return null;
        }
        return this._componentServices.get(componentServiceName);
    }

    public void setComponentServices(List<ComponentService> services) {
        this._componentServices = new LinkedHashMap<QName, ComponentService>();
        for (ComponentService service : services) {
            this._componentServices.put(service.getName(), service);
        }
    }

    protected void addComponentService(ComponentService service) {
        this._componentServices.put(service.getName(), service);
    }

    protected ComponentService removeComponentService(QName serviceName) {
        ComponentService service = this._componentServices.remove(serviceName);
        return service;
    }

    @Override
    public List<Transformer> getTransformers() {
        return Collections.unmodifiableList(this._transformers);
    }

    protected void setTransformers(List<Transformer> transformers) {
        this._transformers.clear();
        this._transformers.addAll(transformers);
    }

    protected void addTransformer(Transformer transformer) {
        this._transformers.add(transformer);
    }
}

