/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.admin.base;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.xml.namespace.QName;
import org.switchyard.admin.Application;
import org.switchyard.admin.Component;
import org.switchyard.admin.Service;
import org.switchyard.admin.SwitchYard;

public class BaseSwitchYard
implements SwitchYard {
    private String _version;
    private ConcurrentMap<QName, Application> _applications = new ConcurrentHashMap<QName, Application>();
    private ConcurrentMap<String, Component> _components = new ConcurrentHashMap<String, Component>();
    private List<Service> _services = Collections.synchronizedList(new LinkedList());
    private Set<String> _socketBindingNames = Collections.synchronizedSet(new HashSet());
    private ConcurrentMap<String, String> _properties = new ConcurrentHashMap<String, String>();

    public BaseSwitchYard(String version) {
        this._version = version;
    }

    @Override
    public List<Application> getApplications() {
        return new ArrayList<Application>(this._applications.values());
    }

    public BaseSwitchYard addApplication(Application application) {
        Application existing = this._applications.putIfAbsent(application.getName(), application);
        if (existing == null) {
            this._services.addAll(application.getServices());
        }
        return this;
    }

    public BaseSwitchYard removeApplication(Application application) {
        return this.removeApplication(application.getName());
    }

    public BaseSwitchYard removeApplication(QName name) {
        Application application = (Application)this._applications.remove(name);
        if (application != null) {
            this._services.removeAll(application.getServices());
        }
        return this;
    }

    @Override
    public List<Component> getComponents() {
        return new ArrayList<Component>(this._components.values());
    }

    public BaseSwitchYard addComponent(Component component) {
        this._components.putIfAbsent(component.getName(), component);
        return this;
    }

    public BaseSwitchYard removeComponent(Component component) {
        this._components.remove(component.getName());
        return this;
    }

    @Override
    public List<Service> getServices() {
        return new ArrayList<Service>(this._services);
    }

    public BaseSwitchYard addService(Service service) {
        this._services.add(service);
        return this;
    }

    public BaseSwitchYard removeService(Service service) {
        this._services.remove(service);
        return this;
    }

    @Override
    public String getVersion() {
        return this._version;
    }

    public void setVersion(String version) {
        this._version = version;
    }

    @Override
    public Component getComponent(String name) {
        return (Component)this._components.get(name);
    }

    @Override
    public Application getApplication(QName name) {
        return (Application)this._applications.get(name);
    }

    public void addSocketBindingNames(Set<String> names) {
        this._socketBindingNames.addAll(names);
    }

    public void addSocketBindingName(String name) {
        this._socketBindingNames.add(name);
    }

    public void removeSocketBindingName(String name) {
        this._socketBindingNames.remove(name);
    }

    public void removeSocketBindingNames(Set<String> names) {
        this._socketBindingNames.removeAll(names);
    }

    @Override
    public Set<String> getSocketBindingNames() {
        return Collections.unmodifiableSet(this._socketBindingNames);
    }

    @Override
    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this._properties);
    }

    public void addProperties(Map<String, String> properties) {
        this._properties.putAll(properties);
    }

    public void addProperty(String name, String value) {
        this._properties.put(name, value);
    }

    public void removeProperties(Map<String, String> properties) {
        this._properties.keySet().removeAll(properties.keySet());
    }

    public void removeProperty(String name) {
        this._properties.remove(name);
    }
}

