/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.admin.mbean.internal;

import java.lang.management.ManagementFactory;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.log4j.Logger;
import org.switchyard.SwitchYardException;
import org.switchyard.admin.Application;
import org.switchyard.admin.Binding;
import org.switchyard.admin.ComponentReference;
import org.switchyard.admin.ComponentService;
import org.switchyard.admin.Reference;
import org.switchyard.admin.Service;
import org.switchyard.admin.Throttling;
import org.switchyard.admin.Transformer;
import org.switchyard.admin.Validator;
import org.switchyard.admin.mbean.internal.LocalManagement;
import org.switchyard.admin.mbean.internal.ManagedApplication;
import org.switchyard.admin.mbean.internal.ManagedBinding;
import org.switchyard.admin.mbean.internal.ManagedComponentReference;
import org.switchyard.admin.mbean.internal.ManagedComponentService;
import org.switchyard.admin.mbean.internal.ManagedReference;
import org.switchyard.admin.mbean.internal.ManagedService;
import org.switchyard.admin.mbean.internal.ManagedTransformer;
import org.switchyard.admin.mbean.internal.ManagedValidator;

public final class MBeans {
    public static final String DOMAIN = "org.switchyard.admin";
    static final String APPLICATION = "type=Application,name=";
    static final String SERVICE = "type=Service,name=";
    static final String REFERENCE = "type=Reference,name=";
    static final String BINDING = "type=Binding,name=";
    static final String TRANSFORMER = "type=Transformer,name=";
    static final String VALIDATOR = "type=Validator,name=";
    static final String COMPONENT_SERVICE = "type=ComponentService,name=";
    static final String COMPONENT_REFERENCE = "type=ComponentReference,name=";
    static final String LOCAL_MANAGEMENT = "type=Management.Local";
    static final String THROTTLING = "type=Throttling,service=";
    private static MBeanServer _server = ManagementFactory.getPlatformMBeanServer();
    private static Logger _log = Logger.getLogger(MBeans.class);

    private MBeans() {
    }

    public static void registerLocalManagement(LocalManagement localManage) {
        MBeans.registerMBean(localManage, MBeans.toName("org.switchyard.admin:type=Management.Local"));
    }

    public static void unregisterLocalManagement() {
        MBeans.unregisterMBean(MBeans.toName("org.switchyard.admin:type=Management.Local"));
    }

    public static void registerApplication(Application application) {
        ManagedBinding mBind;
        ManagedApplication mApp = new ManagedApplication(application);
        MBeans.registerMBean(mApp, MBeans.getObjectName(application));
        for (Service service : application.getServices()) {
            ManagedService mSvc = new ManagedService(service, mApp);
            MBeans.registerMBean(mSvc, MBeans.getObjectName(service));
            MBeans.registerMBean(mSvc.getThrottling(), MBeans.getObjectName(service, service.getThrottling()));
            for (Binding binding : service.getGateways()) {
                mBind = new ManagedBinding(binding);
                MBeans.registerMBean(mBind, MBeans.getObjectName(service, binding));
                mSvc.addBinding(mBind);
            }
        }
        for (Reference reference : application.getReferences()) {
            ManagedReference mRef = new ManagedReference(reference, mApp);
            MBeans.registerMBean(mRef, MBeans.getObjectName(reference));
            for (Binding binding : reference.getGateways()) {
                mBind = new ManagedBinding(binding);
                MBeans.registerMBean(mBind, MBeans.getObjectName(reference, binding));
                mRef.addBinding(mBind);
            }
        }
        for (Transformer trans : application.getTransformers()) {
            ManagedTransformer mTrans = new ManagedTransformer(trans);
            MBeans.registerMBean(mTrans, MBeans.getObjectName(trans));
        }
        for (Validator val : application.getValidators()) {
            ManagedValidator mVal = new ManagedValidator(val);
            MBeans.registerMBean(mVal, MBeans.getObjectName(val));
        }
        for (ComponentService cs : application.getComponentServices()) {
            ManagedComponentService mCS = new ManagedComponentService(cs, mApp);
            MBeans.registerMBean(mCS, MBeans.getObjectName(cs));
            for (ComponentReference cr : cs.getReferences()) {
                ManagedComponentReference mCR = new ManagedComponentReference(cr);
                MBeans.registerMBean(mCR, MBeans.getObjectName(cs, cr));
            }
        }
    }

    public static void unregisterApplication(Application application) {
        MBeans.unregisterMBean(MBeans.getObjectName(application));
        for (Service service : application.getServices()) {
            MBeans.unregisterMBean(MBeans.getObjectName(service));
            MBeans.unregisterMBean(MBeans.getObjectName(service, service.getThrottling()));
            for (Binding binding : service.getGateways()) {
                MBeans.unregisterMBean(MBeans.getObjectName(service, binding));
            }
        }
        for (Reference reference : application.getReferences()) {
            MBeans.unregisterMBean(MBeans.getObjectName(reference));
            for (Binding binding : reference.getGateways()) {
                MBeans.unregisterMBean(MBeans.getObjectName(reference, binding));
            }
        }
        for (Transformer trans : application.getTransformers()) {
            MBeans.unregisterMBean(MBeans.getObjectName(trans));
        }
        for (Validator val : application.getValidators()) {
            MBeans.unregisterMBean(MBeans.getObjectName(val));
        }
        for (ComponentService cs : application.getComponentServices()) {
            MBeans.unregisterMBean(MBeans.getObjectName(cs));
            for (ComponentReference cr : cs.getReferences()) {
                MBeans.unregisterMBean(MBeans.getObjectName(cs, cr));
            }
        }
    }

    private static void registerMBean(Object obj, ObjectName name) {
        try {
            _server.registerMBean(obj, name);
        }
        catch (Exception ex) {
            _log.debug((Object)("Failed to register SwitchYard MBean: " + name), (Throwable)ex);
        }
    }

    private static void unregisterMBean(ObjectName name) throws SwitchYardException {
        try {
            _server.unregisterMBean(name);
        }
        catch (Exception ex) {
            _log.debug((Object)("Failed to unregister SwitchYard MBean: " + name), (Throwable)ex);
        }
    }

    static ObjectName getObjectName(Application application) {
        return MBeans.toName("org.switchyard.admin:type=Application,name=" + ObjectName.quote(application.getName().toString()));
    }

    static ObjectName getObjectName(Service service) {
        return MBeans.toName("org.switchyard.admin:type=Service,name=" + ObjectName.quote(service.getName().toString()));
    }

    static ObjectName getObjectName(Reference reference) {
        return MBeans.toName("org.switchyard.admin:type=Reference,name=" + ObjectName.quote(reference.getName().toString()));
    }

    static ObjectName getObjectName(ComponentService compSvc) {
        return MBeans.toName("org.switchyard.admin:type=ComponentService,name=" + ObjectName.quote(compSvc.getName().toString()));
    }

    static ObjectName getObjectName(Transformer transformer) {
        return MBeans.toName("org.switchyard.admin:type=Transformer,name=" + ObjectName.quote(transformer.getFrom() + " => " + transformer.getTo()));
    }

    static ObjectName getObjectName(Validator validator) {
        return MBeans.toName("org.switchyard.admin:type=Validator,name=" + ObjectName.quote(validator.getName().toString()));
    }

    static ObjectName getObjectName(ComponentService service, ComponentReference reference) {
        return MBeans.toName("org.switchyard.admin:type=ComponentReference,name=" + ObjectName.quote(reference.getName().toString()) + ",service=" + ObjectName.quote(service.getName().toString()));
    }

    static ObjectName getObjectName(Service service, Binding binding) {
        return MBeans.toName("org.switchyard.admin:type=Binding,name=" + ObjectName.quote(binding.getName()) + ",service=" + ObjectName.quote(service.getName().toString()));
    }

    static ObjectName getObjectName(Reference reference, Binding binding) {
        return MBeans.toName("org.switchyard.admin:type=Binding,name=" + ObjectName.quote(binding.getName()) + ",reference=" + ObjectName.quote(reference.getName().toString()));
    }

    static ObjectName getObjectName(Service service, Throttling throttling) {
        return MBeans.toName("org.switchyard.admin:type=Throttling,service=" + ObjectName.quote(service.getName().toString()));
    }

    private static ObjectName toName(String nameStr) {
        try {
            return new ObjectName(nameStr);
        }
        catch (MalformedObjectNameException badNameEx) {
            throw new IllegalArgumentException(badNameEx);
        }
    }
}

