/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.admin.base;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.switchyard.Exchange;
import org.switchyard.ExchangeState;
import org.switchyard.Property;
import org.switchyard.admin.AdminMessages;
import org.switchyard.admin.MessageMetrics;

public class MessageMetricsSupport
implements MessageMetrics {
    private static final String NL = System.getProperty("line.separator");
    private AtomicInteger _successCount = new AtomicInteger();
    private AtomicInteger _faultCount = new AtomicInteger();
    private AtomicInteger _minTimeMS = new AtomicInteger();
    private AtomicInteger _maxTimeMS = new AtomicInteger();
    private AtomicLong _totalTimeMS = new AtomicLong();

    public synchronized void recordMetrics(Exchange exchange) {
        if (exchange.getState().equals((Object)ExchangeState.FAULT)) {
            this._faultCount.incrementAndGet();
        } else {
            this._successCount.incrementAndGet();
        }
        Property prop = exchange.getContext().getProperty("org.switchyard.exchangeDurationMS");
        if (prop != null) {
            Long duration = (Long)prop.getValue();
            this._totalTimeMS.addAndGet(duration);
            if (this._minTimeMS.intValue() == 0 || duration < (long)this._minTimeMS.intValue()) {
                this._minTimeMS.set(duration.intValue());
            }
            if (this._maxTimeMS.intValue() == 0 || duration > (long)this._maxTimeMS.intValue()) {
                this._maxTimeMS.set(duration.intValue());
            }
        }
    }

    public synchronized void reset() {
        this._successCount.set(0);
        this._faultCount.set(0);
        this._minTimeMS.set(0);
        this._maxTimeMS.set(0);
        this._totalTimeMS.set(0L);
    }

    @Override
    public int getTotalCount() {
        return this._successCount.get() + this._faultCount.get();
    }

    @Override
    public int getFaultCount() {
        return this._faultCount.get();
    }

    @Override
    public int getSuccessCount() {
        return this._successCount.get();
    }

    @Override
    public long getTotalProcessingTime() {
        return this._totalTimeMS.get();
    }

    @Override
    public synchronized double getAverageProcessingTime() {
        if (this.getTotalCount() == 0) {
            return 0.0;
        }
        return (double)this.getTotalProcessingTime() / (double)this.getTotalCount();
    }

    @Override
    public int getMaxProcessingTime() {
        return this._maxTimeMS.get();
    }

    @Override
    public int getMinProcessingTime() {
        return this._minTimeMS.get();
    }

    public String toString() {
        return AdminMessages.MESSAGES.messageMetricsString(this.getSuccessCount() + NL, this.getFaultCount() + NL, this.getTotalCount() + NL, this.getAverageProcessingTime() + NL, this.getMinProcessingTime() + NL, this.getMaxProcessingTime() + NL, this.getTotalProcessingTime() + NL);
    }
}

