/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.io;

import java.io.IOException;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;

public final class Serialization {
    private Serialization() {
    }

    public static final class DefaultFactory<T>
    implements Factory<T> {
        @Override
        public T create(Class<T> type) throws IOException {
            try {
                Constructor<T> cnst = type.getConstructor(new Class[0]);
                if (!cnst.isAccessible()) {
                    cnst.setAccessible(true);
                }
                return cnst.newInstance(new Object[0]);
            }
            catch (Exception e) {
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw new IOException(e);
            }
        }
    }

    public static interface Factory<T> {
        public T create(Class<T> var1) throws IOException;
    }

    @Target(value={ElementType.FIELD, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    public static @interface Exclude {
    }

    @Target(value={ElementType.FIELD, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    public static @interface Include {
    }

    public static enum CoverageType {
        INCLUSIVE,
        EXCLUSIVE;

    }

    public static enum AccessType {
        BEAN,
        FIELD;

    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    public static @interface Strategy {
        public AccessType access() default AccessType.BEAN;

        public CoverageType coverage() default CoverageType.INCLUSIVE;

        public Class<? extends Factory> factory() default DefaultFactory.class;
    }
}

