/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.policy;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.switchyard.policy.Policy;
import org.switchyard.policy.SecurityPolicy;
import org.switchyard.policy.TransactionPolicy;

public final class PolicyFactory {
    private static Set<Policy> _policies = new HashSet<Policy>();

    private PolicyFactory() {
    }

    public static Policy getPolicy(String name) throws Exception {
        for (Policy p : _policies) {
            if (!p.getName().equals(name)) continue;
            return p;
        }
        throw new Exception("Invalid policy name: '" + name + "' doesn't exist.");
    }

    static {
        _policies.addAll(Arrays.asList(TransactionPolicy.values()));
        _policies.addAll(Arrays.asList(SecurityPolicy.values()));
    }
}

