/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.policy;

import org.switchyard.policy.Policy;

public enum TransactionPolicy implements Policy
{
    MANAGED_TRANSACTION_GLOBAL("managedTransaction.Global"){

        @Override
        public Policy.PolicyType getType() {
            return Policy.PolicyType.IMPLEMENTATION;
        }

        @Override
        public boolean isCompatibleWith(Policy target) {
            return target != MANAGED_TRANSACTION_LOCAL && target != NO_MANAGED_TRANSACTION;
        }
    }
    ,
    MANAGED_TRANSACTION_LOCAL("managedTransaction.Local"){

        @Override
        public Policy.PolicyType getType() {
            return Policy.PolicyType.IMPLEMENTATION;
        }

        @Override
        public boolean isCompatibleWith(Policy target) {
            return target != MANAGED_TRANSACTION_GLOBAL && target != NO_MANAGED_TRANSACTION && target != PROPAGATES_TRANSACTION;
        }

        @Override
        public Policy getPolicyDependency() {
            return SUSPENDS_TRANSACTION;
        }
    }
    ,
    NO_MANAGED_TRANSACTION("noManagedTransaction"){

        @Override
        public Policy.PolicyType getType() {
            return Policy.PolicyType.IMPLEMENTATION;
        }

        @Override
        public boolean isCompatibleWith(Policy target) {
            return target != MANAGED_TRANSACTION_GLOBAL && target != MANAGED_TRANSACTION_LOCAL && target != PROPAGATES_TRANSACTION;
        }
    }
    ,
    PROPAGATES_TRANSACTION("propagatesTransaction"){

        @Override
        public Policy.PolicyType getType() {
            return Policy.PolicyType.INTERACTION;
        }

        @Override
        public boolean isCompatibleWith(Policy target) {
            return target != MANAGED_TRANSACTION_LOCAL && target != NO_MANAGED_TRANSACTION && target != SUSPENDS_TRANSACTION;
        }
    }
    ,
    SUSPENDS_TRANSACTION("suspendsTransaction"){

        @Override
        public Policy.PolicyType getType() {
            return Policy.PolicyType.INTERACTION;
        }

        @Override
        public boolean isCompatibleWith(Policy target) {
            return target != PROPAGATES_TRANSACTION;
        }
    };

    private String _name;

    private TransactionPolicy(String name) {
        this._name = name;
    }

    @Override
    public String getName() {
        return this._name;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public Policy getPolicyDependency() {
        return null;
    }
}

