/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.metadata;

import java.util.Collections;
import java.util.List;
import org.switchyard.ServiceMetadata;
import org.switchyard.ServiceSecurity;
import org.switchyard.metadata.Registrant;
import org.switchyard.metadata.qos.Throttling;
import org.switchyard.policy.Policy;

public final class ServiceMetadataBuilder {
    private ServiceMetadataImpl _metadata;

    private ServiceMetadataBuilder() {
        this._metadata = new ServiceMetadataImpl();
    }

    private ServiceMetadataBuilder(ServiceMetadataImpl metadata) {
        this._metadata = metadata;
    }

    public ServiceMetadataBuilder security(ServiceSecurity security) {
        this._metadata._security = security;
        return this;
    }

    public ServiceMetadataBuilder requiredPolicies(List<Policy> requiredPolicies) {
        this._metadata._requiredPolicies = requiredPolicies;
        return this;
    }

    public ServiceMetadataBuilder providedPolicies(List<Policy> providedPolicies) {
        this._metadata._providedPolicies = providedPolicies;
        return this;
    }

    public ServiceMetadataBuilder registrant(Registrant registrant) {
        this._metadata._registrant = registrant;
        return this;
    }

    public ServiceMetadataBuilder throttling(Throttling throttling) {
        this._metadata._throttling = throttling;
        return this;
    }

    public ServiceMetadata build() {
        return this._metadata;
    }

    public static ServiceMetadataBuilder create() {
        return new ServiceMetadataBuilder();
    }

    public static ServiceMetadataBuilder update(ServiceMetadata metadata) {
        if (!ServiceMetadataImpl.class.isInstance(metadata)) {
            throw new IllegalArgumentException("Unable to update metadata type " + metadata.getClass());
        }
        return new ServiceMetadataBuilder((ServiceMetadataImpl)metadata);
    }

    public static ServiceMetadataBuilder createFrom(ServiceMetadata metadata) {
        return ServiceMetadataBuilder.create().security(metadata.getSecurity()).registrant(metadata.getRegistrant()).requiredPolicies(metadata.getRequiredPolicies()).providedPolicies(metadata.getProvidedPolicies());
    }

    private class ServiceMetadataImpl
    implements ServiceMetadata {
        private ServiceSecurity _security;
        private List<Policy> _requiredPolicies = Collections.emptyList();
        private List<Policy> _providedPolicies = Collections.emptyList();
        private Registrant _registrant;
        private Throttling _throttling;

        private ServiceMetadataImpl() {
        }

        @Override
        public ServiceSecurity getSecurity() {
            return this._security;
        }

        @Override
        public List<Policy> getRequiredPolicies() {
            return this._requiredPolicies;
        }

        @Override
        public List<Policy> getProvidedPolicies() {
            return this._providedPolicies;
        }

        @Override
        public Registrant getRegistrant() {
            return this._registrant;
        }

        @Override
        public Throttling getThrottling() {
            return this._throttling;
        }
    }
}

