/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.policy;

import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import org.switchyard.Exchange;
import org.switchyard.Property;
import org.switchyard.Scope;
import org.switchyard.label.BehaviorLabel;
import org.switchyard.policy.Policy;

public final class PolicyUtil {
    public static final String PROVIDED_PROPERTY = "org.switchyard.policy.provided";
    public static final String REQUIRED_PROPERTY = "org.switchyard.policy.required";

    private PolicyUtil() {
    }

    public static void provide(Exchange exchange, Policy policy) {
        Set<Policy> provided = PolicyUtil.getPolicies(exchange, PROVIDED_PROPERTY);
        provided.add(policy);
        exchange.getContext().setProperty(PROVIDED_PROPERTY, provided, Scope.EXCHANGE).addLabels(BehaviorLabel.TRANSIENT.label());
    }

    public static Set<Policy> getProvided(Exchange exchange) {
        return PolicyUtil.getPolicies(exchange, PROVIDED_PROPERTY);
    }

    public static boolean isProvided(Exchange exchange, Policy policy) {
        return PolicyUtil.containsPolicy(PolicyUtil.getProvided(exchange), policy);
    }

    public static void require(Exchange exchange, Policy policy) {
        Set<Policy> required = PolicyUtil.getPolicies(exchange, REQUIRED_PROPERTY);
        required.add(policy);
        exchange.getContext().setProperty(REQUIRED_PROPERTY, required, Scope.EXCHANGE).addLabels(BehaviorLabel.TRANSIENT.label());
    }

    public static Set<Policy> getRequired(Exchange exchange) {
        return PolicyUtil.getPolicies(exchange, REQUIRED_PROPERTY);
    }

    public static boolean isRequired(Exchange exchange, Policy policy) {
        return PolicyUtil.containsPolicy(PolicyUtil.getRequired(exchange), policy);
    }

    private static Set<Policy> getPolicies(Exchange exchange, String propertyName) {
        Property intentsProperty = exchange.getContext().getProperty(propertyName, Scope.EXCHANGE);
        HashSet<Policy> intents = new HashSet<Policy>();
        if (intentsProperty != null) {
            intents.addAll((Set)intentsProperty.getValue());
        }
        return intents;
    }

    private static boolean containsPolicy(Set<Policy> list, Policy target) {
        QName qname = target.getQName();
        for (Policy p : list) {
            if (p.getQName().equals(qname)) {
                return true;
            }
            if (!"".equals(qname.getNamespaceURI()) || !qname.getLocalPart().equals(p.getQName().getLocalPart())) continue;
            return true;
        }
        return false;
    }
}

