/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.internal.io.graph;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.switchyard.internal.io.graph.Graph;

public class InputStreamGraph
implements Graph<InputStream> {
    private byte[] _bytes;

    public byte[] getBytes() {
        return this._bytes;
    }

    public void setBytes(byte[] bytes) {
        this._bytes = bytes;
    }

    @Override
    public void compose(InputStream object, Map<Integer, Object> visited) throws IOException {
        int bs = 256;
        BufferedInputStream bis = new BufferedInputStream(object, bs);
        ByteArrayOutputStream baos = new ByteArrayOutputStream(bs);
        BufferedOutputStream bos = new BufferedOutputStream(baos, bs);
        byte[] buff = new byte[bs];
        int read = 0;
        while ((read = bis.read(buff)) != -1) {
            bos.write(buff, 0, read);
        }
        bos.flush();
        this.setBytes(baos.toByteArray());
    }

    @Override
    public InputStream decompose(Map<Integer, Object> visited) throws IOException {
        return new ByteArrayInputStream(this.getBytes());
    }

    public String toString() {
        byte[] bytes = this.getBytes();
        return "InputStreamGraph(bytes.length=" + (bytes != null ? Integer.valueOf(bytes.length) : "null") + ")";
    }
}

