/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.transform;

import java.io.Serializable;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.log4j.Logger;
import org.switchyard.Exchange;
import org.switchyard.Message;
import org.switchyard.Property;
import org.switchyard.Scope;
import org.switchyard.transform.Transformer;
import org.switchyard.transform.TransformerRegistry;

public final class TransformSequence
implements Serializable {
    static final long serialVersionUID = -1L;
    private static final Logger LOGGER = Logger.getLogger(TransformSequence.class);
    private List<QName> _sequence = new ArrayList<QName>();

    private TransformSequence() {
    }

    public void associateWith(Exchange exchange, Scope scope) {
        exchange.getContext().setProperty(TransformSequence.class.getName(), this, scope);
    }

    public static TransformSequence from(QName typeName) {
        TransformSequence newSequence = new TransformSequence();
        newSequence.add(typeName);
        return newSequence;
    }

    public TransformSequence to(QName typeName) {
        this.add(typeName);
        return this;
    }

    public void apply(Message message, TransformerRegistry registry) {
        QName to;
        QName from;
        Transformer<?, ?> transformer;
        while (this._sequence.size() > 1 && (transformer = registry.getTransformer(from = this._sequence.get(0), to = this._sequence.get(1))) != null) {
            Object result;
            if (Message.class.isAssignableFrom(this.getFromType(transformer))) {
                result = transformer.transform(message);
            } else {
                result = transformer.transform(message.getContent());
                if (result != null) {
                    message.setContent(result);
                }
            }
            if (result != null) {
                this._sequence.remove(0);
                continue;
            }
            LOGGER.warn((Object)("Transformer '" + transformer.getClass().getName() + "' returned a null transformation result.  Check input payload matches requirements of the Transformer implementation."));
            break;
        }
    }

    public static QName getCurrentMessageType(Exchange exchange) {
        TransformSequence transformSequence = TransformSequence.get(exchange);
        if (transformSequence != null && !transformSequence._sequence.isEmpty()) {
            return transformSequence._sequence.get(0);
        }
        return null;
    }

    public static QName getTargetMessageType(Exchange exchange) {
        TransformSequence transformSequence = TransformSequence.get(exchange);
        if (transformSequence != null && !transformSequence._sequence.isEmpty()) {
            return transformSequence._sequence.get(transformSequence._sequence.size() - 1);
        }
        return null;
    }

    public static boolean assertTransformsApplied(Exchange exchange) {
        QName fromName = TransformSequence.getCurrentMessageType(exchange);
        QName toName = TransformSequence.getTargetMessageType(exchange);
        return fromName == null || toName == null || fromName.equals(toName);
    }

    public static void applySequence(Exchange exchange, TransformerRegistry registry) {
        Message message = exchange.getMessage();
        TransformSequence transformSequence = TransformSequence.get(exchange);
        if (transformSequence == null) {
            return;
        }
        transformSequence.apply(message, registry);
    }

    private void add(QName typeName) {
        if (typeName == null) {
            throw new IllegalArgumentException("null 'typeName' arg passed.");
        }
        this._sequence.add(typeName);
    }

    private static TransformSequence get(Exchange exchange) {
        Property sequenceProperty = exchange.getContext().getProperty(TransformSequence.class.getName(), Scope.activeScope(exchange));
        if (sequenceProperty != null) {
            return (TransformSequence)sequenceProperty.getValue();
        }
        return null;
    }

    private Class<?> getFromType(Transformer transformer) {
        try {
            ParameterizedType pt = (ParameterizedType)transformer.getClass().getGenericSuperclass();
            return (Class)pt.getActualTypeArguments()[0];
        }
        catch (Exception e) {
            return Object.class;
        }
    }
}

