/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.transform;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.switchyard.common.type.Classes;
import org.switchyard.config.model.ModelResource;
import org.switchyard.config.model.transform.TransformModel;
import org.switchyard.config.model.transform.TransformsModel;
import org.switchyard.exception.SwitchYardException;
import org.switchyard.transform.Transformer;
import org.switchyard.transform.TransformerRegistry;
import org.switchyard.transform.config.model.TransformerFactory;

public class TransformerRegistryLoader {
    private static Logger _log = Logger.getLogger(TransformerRegistryLoader.class);
    public static final String TRANSFORMS_XML = "META-INF/switchyard/transforms.xml";
    private List<Transformer> _transformers = new LinkedList<Transformer>();
    private TransformerRegistry _transformerRegistry;

    public TransformerRegistryLoader(TransformerRegistry transformerRegistry) {
        if (transformerRegistry == null) {
            throw new IllegalArgumentException("null 'transformerRegistry' argument.");
        }
        this._transformerRegistry = transformerRegistry;
    }

    public void registerTransformers(TransformsModel transforms) {
        if (transforms == null) {
            return;
        }
        try {
            for (TransformModel transformModel : transforms.getTransforms()) {
                Collection<Transformer<?, ?>> transformers = TransformerFactory.newTransformers(transformModel);
                for (Transformer<?, ?> transformer : transformers) {
                    if (this._transformerRegistry.hasTransformer(transformer.getFrom(), transformer.getTo())) {
                        Transformer registeredTransformer = this._transformerRegistry.getTransformer(transformer.getFrom(), transformer.getTo());
                        throw new SwitchYardException("Failed to register Transformer '" + this.toDescription(transformer) + "'.  A Transformer for these types is already registered: '" + this.toDescription(registeredTransformer) + "'.");
                    }
                    _log.debug((Object)("Adding transformer => From: " + transformer.getFrom() + ", To:" + transformer.getTo()));
                    this._transformerRegistry.addTransformer(transformer);
                    this._transformers.add(transformer);
                }
            }
        }
        catch (RuntimeException e) {
            this.unregisterTransformers();
            throw e;
        }
    }

    public void unregisterTransformers() {
        for (Transformer transformer : this._transformers) {
            this._transformerRegistry.removeTransformer(transformer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadOOTBTransforms() {
        try {
            List resources = Classes.getResources((String)TRANSFORMS_XML, this.getClass());
            for (URL resource : resources) {
                InputStream configStream = resource.openStream();
                try {
                    TransformsModel transformsModel = (TransformsModel)new ModelResource().pull(configStream);
                    this.registerTransformers(transformsModel);
                }
                finally {
                    configStream.close();
                }
            }
        }
        catch (IOException e) {
            throw new SwitchYardException("Error reading out-of-the-box Transformer configurations from classpath (META-INF/switchyard/transforms.xml).", (Throwable)e);
        }
    }

    private String toDescription(Transformer<?, ?> transformer) {
        return transformer.getClass().getName() + "(" + transformer.getFrom() + ", " + transformer.getTo() + ")";
    }
}

