/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.transform.ootb.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import org.apache.log4j.Logger;
import org.switchyard.annotations.Transformer;
import org.xml.sax.InputSource;

public class ReaderTransforms {
    public static final ReaderTransforms TRANSFORMER = new ReaderTransforms();
    private static final Logger LOGGER = Logger.getLogger(ReaderTransforms.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Transformer
    public String toString(Reader reader) {
        StringBuilder builder = new StringBuilder();
        try {
            int readCount;
            char[] readBuffer = new char[56];
            while ((readCount = reader.read(readBuffer)) != -1) {
                builder.append(readBuffer, 0, readCount);
            }
        }
        catch (IOException e) {
            LOGGER.debug((Object)"Error reading from reader.", (Throwable)e);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                LOGGER.debug((Object)"Failed to close reader instance.", (Throwable)e);
            }
        }
        return builder.toString();
    }

    @Transformer
    public InputStream toInputStream(Reader reader) {
        return new ByteArrayInputStream(this.toString(reader).getBytes());
    }

    @Transformer
    public InputSource toInputSource(Reader reader) {
        String string = this.toString(reader);
        InputSource inputSource = new InputSource();
        inputSource.setByteStream(new ByteArrayInputStream(string.getBytes()));
        inputSource.setCharacterStream(new StringReader(string));
        return inputSource;
    }

    @Transformer
    public Integer toInteger(Reader reader) {
        return Integer.parseInt(this.toString(reader));
    }

    @Transformer
    public Long toLong(Reader reader) {
        return Long.parseLong(this.toString(reader));
    }

    @Transformer
    public Short toShort(Reader reader) {
        return Short.parseShort(this.toString(reader));
    }

    @Transformer
    public char[] toChars(Reader reader) {
        return this.toString(reader).toCharArray();
    }

    @Transformer
    public Character toCharacter(Reader reader) {
        return Character.valueOf(this.toString(reader).charAt(0));
    }

    @Transformer
    public byte[] toBytes(Reader reader) {
        return this.toString(reader).getBytes();
    }

    @Transformer
    public Double toDouble(Reader reader) {
        return Double.parseDouble(this.toString(reader));
    }

    @Transformer
    public Float toFloat(Reader reader) {
        return Float.valueOf(Float.parseFloat(this.toString(reader)));
    }
}

