/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.transform.smooks.internal;

import javax.xml.namespace.QName;
import org.milyn.Smooks;
import org.milyn.container.ApplicationContext;
import org.milyn.javabean.binding.model.ModelSet;
import org.switchyard.exception.SwitchYardException;
import org.switchyard.transform.Transformer;
import org.switchyard.transform.config.model.SmooksTransformModel;
import org.switchyard.transform.smooks.SmooksTransformType;
import org.switchyard.transform.smooks.internal.SmooksTransformer;
import org.switchyard.transform.smooks.internal.XMLBindingTransformer;

public final class SmooksTransformFactory {
    private SmooksTransformFactory() {
    }

    public static Transformer newTransformer(SmooksTransformModel model) {
        Object transformer;
        Smooks smooks;
        String transformType = model.getTransformType();
        String config = model.getConfig();
        QName from = model.getFrom();
        QName to = model.getTo();
        if (transformType == null || transformType.trim().length() == 0) {
            throw new SwitchYardException("Invalid Smooks configuration model.  null or empty 'type' specification.");
        }
        if (config == null || config.trim().length() == 0) {
            throw new SwitchYardException("Invalid Smooks configuration model.  null or empty 'config' specification.");
        }
        if (from == null) {
            throw new SwitchYardException("Invalid Smooks configuration model.  null or 'from' specification.");
        }
        if (to == null) {
            throw new SwitchYardException("Invalid Smooks configuration model.  null or 'to' specification.");
        }
        SmooksTransformType transformationType = SmooksTransformType.valueOf(transformType);
        try {
            smooks = new Smooks(config);
            smooks.createExecutionContext();
        }
        catch (Exception e) {
            throw new SwitchYardException("Failed to create Smooks instance for config '" + config + "'.", (Throwable)e);
        }
        if (transformationType == SmooksTransformType.JAVA2XML) {
            transformer = SmooksTransformFactory.newXMLBindingTransformer(from, to, smooks, XMLBindingTransformer.BindingDirection.JAVA2XML);
        } else if (transformationType == SmooksTransformType.XML2JAVA) {
            transformer = SmooksTransformFactory.newXMLBindingTransformer(from, to, smooks, XMLBindingTransformer.BindingDirection.XML2JAVA);
        } else if (transformationType == SmooksTransformType.SMOOKS) {
            transformer = new SmooksTransformer(from, to, smooks, model);
        } else {
            throw new SwitchYardException("Unhandled Smooks transformation type '" + (Object)((Object)transformationType) + "'.");
        }
        transformer.setFrom(model.getFrom());
        transformer.setTo(model.getTo());
        return transformer;
    }

    private static Transformer newXMLBindingTransformer(QName from, QName to, Smooks smooks, XMLBindingTransformer.BindingDirection direction) {
        ModelSet beanModel = ModelSet.get((ApplicationContext)smooks.getApplicationContext());
        if (beanModel != null && !beanModel.getModels().isEmpty()) {
            return new XMLBindingTransformer(from, to, smooks, beanModel, direction);
        }
        throw new SwitchYardException("Invalid " + (Object)((Object)direction) + " binding configuration.  No <jb:bean> configurations found.");
    }
}

