/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.csv;

import au.com.bytecode.opencsv.CSVReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.csv.CSVHeaderValidationException;
import org.milyn.csv.CSVRecordParserFactory;
import org.milyn.flatfile.FieldMetaData;
import org.milyn.flatfile.RecordMetaData;
import org.milyn.flatfile.variablefield.VariableFieldRecordParser;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSVRecordParser<T extends CSVRecordParserFactory>
extends VariableFieldRecordParser<T> {
    private static Log logger = LogFactory.getLog(CSVRecordParser.class);
    private CSVReader csvLineReader;
    private int lineNumber = 0;

    @Override
    public void setDataSource(InputSource source) {
        Reader reader = source.getCharacterStream();
        if (reader == null) {
            throw new IllegalStateException("Invalid InputSource type supplied to CSVRecordParser.  Must contain a Reader instance.");
        }
        CSVRecordParserFactory factory = (CSVRecordParserFactory)this.getFactory();
        this.csvLineReader = new CSVReader(reader, factory.getSeparator(), factory.getQuoteChar(), factory.getSkipLines());
    }

    @Override
    public List<String> nextRecordFieldValues() throws IOException {
        ++this.lineNumber;
        CSVRecordParserFactory factory = (CSVRecordParserFactory)this.getFactory();
        String[] csvRecord = this.csvLineReader.readNext();
        if (csvRecord == null) {
            return null;
        }
        RecordMetaData recordMetaData = factory.getRecordMetaData(csvRecord);
        List<FieldMetaData> fieldsMetaData = recordMetaData.getFields();
        if (this.lineNumber == 1 && factory.validateHeader()) {
            this.validateHeader(csvRecord);
            return this.nextRecordFieldValues();
        }
        if (factory.strict() && csvRecord.length < this.getUnignoredFieldCount(recordMetaData)) {
            logger.debug((Object)("[CORRUPT-CSV] CSV record #" + this.lineNumber + " invalid [" + Arrays.asList(csvRecord) + "].  The record should contain " + fieldsMetaData.size() + " fields [" + recordMetaData.getFieldNames() + "], but contains " + csvRecord.length + " fields.  Ignoring!!"));
            return this.nextRecordFieldValues();
        }
        return Arrays.asList(csvRecord);
    }

    private void validateHeader(String[] headers) throws IOException {
        RecordMetaData recordMetaData = ((CSVRecordParserFactory)this.getFactory()).getRecordMetaData();
        if (headers == null) {
            throw new CSVHeaderValidationException(recordMetaData.getFieldNames());
        }
        if (this.validateHeader(recordMetaData.getFields(), headers)) {
            return;
        }
        throw new CSVHeaderValidationException(recordMetaData.getFieldNames(), Arrays.asList(headers));
    }

    private boolean validateHeader(List<FieldMetaData> fieldsMetaData, String[] headers) {
        if (fieldsMetaData.size() != headers.length) {
            return false;
        }
        int n = 0;
        for (FieldMetaData field : fieldsMetaData) {
            if (!field.ignore()) {
                String name;
                if (headers.length <= n) {
                    return false;
                }
                String header = headers[n];
                if (header == null) {
                    header = "";
                }
                if ((name = field.getName()) == null) {
                    name = "";
                }
                if (!name.equals(header)) {
                    return false;
                }
            }
            ++n;
        }
        return true;
    }
}

