/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.edisax.model;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import org.milyn.assertion.AssertArgument;
import org.milyn.edisax.EDIConfigurationException;
import org.milyn.edisax.model.internal.Component;
import org.milyn.edisax.model.internal.Delimiters;
import org.milyn.edisax.model.internal.Description;
import org.milyn.edisax.model.internal.Edimap;
import org.milyn.edisax.model.internal.Field;
import org.milyn.edisax.model.internal.Import;
import org.milyn.edisax.model.internal.MappingNode;
import org.milyn.edisax.model.internal.ParamEntry;
import org.milyn.edisax.model.internal.Segment;
import org.milyn.edisax.model.internal.SegmentGroup;
import org.milyn.edisax.model.internal.SubComponent;
import org.milyn.edisax.model.internal.ValueNode;
import org.milyn.resource.URIResourceLocator;
import org.milyn.xml.XmlUtil;
import org.milyn.xml.XsdDOMValidator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EDIConfigDigester {
    private URI modelURI;
    private URIResourceLocator importLocator;
    public static final String XSD_V10 = "http://www.milyn.org/schema/edi-message-mapping-1.0.xsd";
    public static final String XSD_V11 = "http://www.milyn.org/schema/edi-message-mapping-1.1.xsd";
    public static final String XSD_V12 = "http://www.milyn.org/schema/edi-message-mapping-1.2.xsd";
    public static final String XSD_V13 = "http://www.milyn.org/schema/edi-message-mapping-1.3.xsd";
    public static final String XSD_V14 = "http://www.milyn.org/schema/edi-message-mapping-1.4.xsd";
    public static final String XSD_V15 = "http://www.milyn.org/schema/edi-message-mapping-1.5.xsd";
    private static final String NAMESPACE_SUFFIX = ":";

    public EDIConfigDigester() {
        this.importLocator = new URIResourceLocator();
    }

    public EDIConfigDigester(URI modelURI, URI importBaseURI) {
        AssertArgument.isNotNull(importBaseURI, "importBaseURI");
        this.modelURI = modelURI;
        this.importLocator = new URIResourceLocator();
        this.importLocator.setBaseURI(importBaseURI);
    }

    public static Edimap digestConfig(InputStream stream) throws IOException, SAXException, EDIConfigurationException {
        return new EDIConfigDigester().digestEDIConfig(stream);
    }

    public Edimap digestEDIConfig(InputStream stream) throws IOException, SAXException, EDIConfigurationException {
        Document configDoc;
        try {
            configDoc = XmlUtil.parseStream(stream);
        }
        catch (ParserConfigurationException ee) {
            throw new SAXException("Unable to parse Smooks configuration.", ee);
        }
        return this.digestEDIConfig(configDoc);
    }

    public Edimap digestEDIConfig(Reader stream) throws IOException, SAXException, EDIConfigurationException {
        Document configDoc;
        try {
            configDoc = XmlUtil.parseStream(stream);
        }
        catch (ParserConfigurationException ee) {
            throw new SAXException("Unable to parse Smooks configuration.", ee);
        }
        return this.digestEDIConfig(configDoc);
    }

    private Edimap digestEDIConfig(Document configDoc) throws SAXException, EDIConfigurationException, IOException {
        XsdDOMValidator validator = new XsdDOMValidator(configDoc);
        if (validator.getNamespaces().size() == 0) {
            throw new EDIConfigurationException("The edi-message-mapping configuration must contain a namespace.");
        }
        if (validator.getNamespaces().size() > 1) {
            throw new EDIConfigurationException("Unsupported use of multiple configuration namespaces from inside the edi-message-mapping configuration.");
        }
        String ediNS = validator.getNamespaces().get(0).toString();
        validator.validate();
        Edimap edimap = new Edimap(this.modelURI);
        if (!EDIConfigDigester.assertValidXSD(ediNS)) {
            throw new SAXException("Cannot parse edi-message-mapping configuration.  Unsupported default Namespace '" + ediNS + "'.");
        }
        this.digestXSDValidatedConfig(configDoc, edimap, ediNS);
        return edimap;
    }

    private static boolean assertValidXSD(String ediNS) {
        return XSD_V10.equals(ediNS) || XSD_V11.equals(ediNS) || XSD_V12.equals(ediNS) || XSD_V13.equals(ediNS) || XSD_V14.equals(ediNS) || XSD_V15.equals(ediNS);
    }

    private void digestXSDValidatedConfig(Document configDoc, Edimap edimap, String schemaName) throws EDIConfigurationException {
        Element documentElement = configDoc.getDocumentElement();
        String namespacePrefix = EDIConfigDigester.retrieveNamespace(documentElement, schemaName);
        NodeList nodes = documentElement.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeName().equalsIgnoreCase(namespacePrefix + "import")) {
                this.digestImport(node, edimap);
                continue;
            }
            if (node.getNodeName().equalsIgnoreCase(namespacePrefix + "description")) {
                EDIConfigDigester.digestDescription(node, edimap);
                continue;
            }
            if (node.getNodeName().equalsIgnoreCase(namespacePrefix + "delimiters")) {
                EDIConfigDigester.digestDelimiters(node, edimap);
                continue;
            }
            if (!node.getNodeName().equalsIgnoreCase(namespacePrefix + "segments")) continue;
            this.digestSegments(node, edimap, namespacePrefix);
        }
    }

    private static void digestDelimiters(Node node, Edimap edimap) {
        Delimiters delimiters = new Delimiters();
        edimap.setDelimiters(delimiters);
        delimiters.setSegment(EDIConfigDigester.getAttributeValue(node, "segment"));
        delimiters.setField(EDIConfigDigester.getAttributeValue(node, "field"));
        delimiters.setFieldRepeat(EDIConfigDigester.getAttributeValue(node, "fieldRepeat"));
        delimiters.setComponent(EDIConfigDigester.getAttributeValue(node, "component"));
        delimiters.setSubComponent(EDIConfigDigester.getAttributeValue(node, "sub-component"));
        delimiters.setEscape(EDIConfigDigester.getAttributeValue(node, "escape"));
        delimiters.setDecimalSeparator(EDIConfigDigester.getAttributeValue(node, "decimalSeparator"));
    }

    private static void digestDescription(Node node, Edimap edimap) {
        Description description = new Description();
        edimap.setDescription(description);
        description.setName(EDIConfigDigester.getAttributeValue(node, "name"));
        description.setVersion(EDIConfigDigester.getAttributeValue(node, "version"));
        String namespace = EDIConfigDigester.getAttributeValue(node, "namespace");
        if (namespace != null) {
            description.setNamespace(namespace);
        } else {
            description.setNamespace("");
        }
    }

    private void digestImport(Node node, Edimap edimap) {
        Import edimapImport = new Import();
        edimap.getImports().add(edimapImport);
        URI resourceURI = this.importLocator.resolveURI(EDIConfigDigester.getAttributeValue(node, "resource"));
        edimapImport.setResourceURI(resourceURI);
        edimapImport.setNamespace(EDIConfigDigester.getAttributeValue(node, "namespace"));
        edimapImport.setTruncatableFields(EDIConfigDigester.getNodeValueAsBoolean(node, "truncatableFields"));
        edimapImport.setTruncatableComponents(EDIConfigDigester.getNodeValueAsBoolean(node, "truncatableComponents"));
        edimapImport.setTruncatableSegments(EDIConfigDigester.getNodeValueAsBoolean(node, "truncatableSegments"));
    }

    private void digestSegments(Node node, Edimap edimap, String namespacePrefix) throws EDIConfigurationException {
        SegmentGroup segments = new SegmentGroup();
        this.setValuesForMappingNode(node, segments, namespacePrefix, null);
        segments.setNamespace(edimap.getDescription().getNamespace());
        edimap.setSegments(segments);
        NodeList nodes = node.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node currentNode = nodes.item(i);
            this.digestSegmentGroup(currentNode, edimap.getSegments().getSegments(), namespacePrefix, segments);
        }
    }

    private void digestSegment(Node node, SegmentGroup segmentGroup, String namespacePrefix, MappingNode parent) throws EDIConfigurationException {
        if (segmentGroup instanceof Segment) {
            Segment segment = (Segment)segmentGroup;
            this.setValuesForSegment(segment, node, namespacePrefix, parent);
            NodeList nodes = node.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node currentNode = nodes.item(i);
                if (currentNode.getNodeName().equalsIgnoreCase(namespacePrefix + "field")) {
                    Field field = new Field();
                    segment.getFields().add(field);
                    this.digestField(currentNode, field, namespacePrefix, segment);
                    continue;
                }
                this.digestSegmentGroup(currentNode, segment.getSegments(), namespacePrefix, segment);
            }
        } else {
            segmentGroup.setMaxOccurs(EDIConfigDigester.getNodeValueAsInteger(node, "maxOccurs"));
            segmentGroup.setMinOccurs(EDIConfigDigester.getNodeValueAsInteger(node, "minOccurs"));
            this.setValuesForMappingNode(node, segmentGroup, namespacePrefix, parent);
            NodeList nodes = node.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node currentNode = nodes.item(i);
                this.digestSegmentGroup(currentNode, segmentGroup.getSegments(), namespacePrefix, segmentGroup);
            }
        }
    }

    private boolean digestSegmentGroup(Node currentNode, List<SegmentGroup> segmentGroupList, String namespacePrefix, MappingNode parent) throws EDIConfigurationException {
        if (currentNode.getNodeName().equalsIgnoreCase(namespacePrefix + "segmentGroup")) {
            SegmentGroup segment = new SegmentGroup();
            segment.setDocumentation(EDIConfigDigester.getNodeValue(currentNode, namespacePrefix + "documentation"));
            segmentGroupList.add(segment);
            this.digestSegment(currentNode, segment, namespacePrefix, parent);
            return true;
        }
        if (currentNode.getNodeName().equalsIgnoreCase(namespacePrefix + "segment")) {
            Segment segment = new Segment();
            segmentGroupList.add(segment);
            this.digestSegment(currentNode, segment, namespacePrefix, parent);
            return true;
        }
        return false;
    }

    private void digestField(Node node, Field field, String namespacePrefix, MappingNode parent) throws EDIConfigurationException {
        this.setValuesForField(field, node, namespacePrefix, parent);
        NodeList nodes = node.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node currentNode = nodes.item(i);
            if (!currentNode.getNodeName().equalsIgnoreCase(namespacePrefix + "component")) continue;
            Component component = new Component();
            field.getComponents().add(component);
            this.digestComponent(currentNode, component, namespacePrefix, field);
        }
    }

    private void digestComponent(Node node, Component component, String namespacePrefix, MappingNode parent) throws EDIConfigurationException {
        this.setValuesForComponent(component, node, namespacePrefix, parent);
        NodeList nodes = node.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node currentNode = nodes.item(i);
            if (!currentNode.getNodeName().equalsIgnoreCase(namespacePrefix + "sub-component")) continue;
            SubComponent subComponent = new SubComponent();
            component.getSubComponents().add(subComponent);
            this.setValuesForSubComponent(currentNode, subComponent, namespacePrefix, component);
        }
    }

    private void setValuesForSegment(Segment segment, Node node, String namespacePrefix, MappingNode parent) {
        segment.setMaxOccurs(EDIConfigDigester.getNodeValueAsInteger(node, "maxOccurs"));
        segment.setMinOccurs(EDIConfigDigester.getNodeValueAsInteger(node, "minOccurs"));
        segment.setSegcode(EDIConfigDigester.getAttributeValue(node, "segcode"));
        segment.setTruncatable(EDIConfigDigester.getNodeValueAsBoolean(node, "truncatable"));
        segment.setIgnoreUnmappedFields(EDIConfigDigester.getNodeValueAsBoolean(node, "ignoreUnmappedFields"));
        segment.setDescription(EDIConfigDigester.getAttributeValue(node, "description"));
        this.setValuesForMappingNode(node, segment, namespacePrefix, parent);
        if (segment.getNodeTypeRef() == null) {
            segment.setNodeTypeRef(EDIConfigDigester.getAttributeValue(node, "segref"));
        }
    }

    private void setValuesForField(Field field, Node node, String namespacePrefix, MappingNode parent) throws EDIConfigurationException {
        field.setRequired(EDIConfigDigester.getNodeValueAsBoolean(node, "required"));
        field.setTruncatable(EDIConfigDigester.getNodeValueAsBoolean(node, "truncatable"));
        this.setValuesForValueNode(node, field, namespacePrefix, parent);
    }

    private void setValuesForComponent(Component component, Node node, String namespacePrefix, MappingNode parent) throws EDIConfigurationException {
        component.setRequired(EDIConfigDigester.getNodeValueAsBoolean(node, "required"));
        component.setTruncatable(EDIConfigDigester.getNodeValueAsBoolean(node, "truncatable"));
        this.setValuesForValueNode(node, component, namespacePrefix, parent);
    }

    private void setValuesForSubComponent(Node node, SubComponent subComponent, String namespacePrefix, MappingNode parent) throws EDIConfigurationException {
        subComponent.setRequired(EDIConfigDigester.getNodeValueAsBoolean(node, "required"));
        this.setValuesForValueNode(node, subComponent, namespacePrefix, parent);
    }

    private void setValuesForMappingNode(Node node, MappingNode mappingNode, String namespacePrefix, MappingNode parent) {
        mappingNode.setXmltag(EDIConfigDigester.getAttributeValue(node, "xmltag"));
        mappingNode.setNodeTypeRef(EDIConfigDigester.getAttributeValue(node, "nodeTypeRef"));
        mappingNode.setDocumentation(EDIConfigDigester.getNodeValue(node, namespacePrefix + "documentation"));
        mappingNode.setParent(parent);
        if (parent != null) {
            mappingNode.setNamespace(parent.getNamespace());
        }
    }

    private void setValuesForValueNode(Node node, ValueNode valueNode, String namespacePrefix, MappingNode parent) throws EDIConfigurationException {
        this.setValuesForMappingNode(node, valueNode, namespacePrefix, parent);
        String type = EDIConfigDigester.getAttributeValue(node, "dataType");
        if (type != null) {
            valueNode.setDataType(type);
        } else {
            valueNode.setDataType(EDIConfigDigester.getAttributeValue(node, "type"));
        }
        valueNode.setMinLength(EDIConfigDigester.getNodeValueAsInteger(node, "minLength"));
        valueNode.setMaxLength(EDIConfigDigester.getNodeValueAsInteger(node, "maxLength"));
        String dataTypeParams = EDIConfigDigester.getAttributeValue(node, "dataTypeParameters");
        if (dataTypeParams != null) {
            EDIConfigDigester.digestParameters(valueNode, dataTypeParams);
        } else {
            EDIConfigDigester.digestParameters(valueNode, EDIConfigDigester.getAttributeValue(node, "typeParameters"));
        }
    }

    private static void digestParameters(ValueNode valueNode, String value) throws EDIConfigurationException {
        if (value != null && !value.equals("")) {
            ArrayList<Map.Entry<String, String>> result = new ArrayList<Map.Entry<String, String>>();
            String[] parameters = value.split(";");
            String customClass = null;
            for (int i = 0; i < parameters.length; ++i) {
                String parameter = parameters[i];
                String[] entry = parameter.split("=");
                if (entry.length == 1) {
                    if (i == 0) {
                        customClass = entry[0];
                        result.add(new ParamEntry<String, String>("decoderClass", entry[0]));
                        continue;
                    }
                    throw new EDIConfigurationException("Invalid use of paramaters in ValueNode. A parameter-entry should consist of a key-value-pair separated with the '='-character. Example: [parameters=\"key1=value1;key2=value2\"]");
                }
                if (entry.length == 2) {
                    result.add(new ParamEntry<String, String>(entry[0], entry[1]));
                    continue;
                }
                throw new EDIConfigurationException("Invalid use of paramaters in ValueNode. A parameter-entry should consist of a key-value-pair separated with the '='-character. Example: [parameters=\"key1=value1;key2=value2\"]");
            }
            valueNode.setDataTypeParameters(result);
            if (valueNode.getDataType().equals("Custom") && customClass == null) {
                throw new EDIConfigurationException("When using the Custom type in ValueNode the custom class type must exist as the first element in parameters");
            }
            if (customClass != null && !valueNode.getDataType().equals("Custom")) {
                throw new EDIConfigurationException("When first parameter in list of parameters is not a key-value-pair the type of the ValueNode should be Custom.");
            }
        }
    }

    private static Boolean getNodeValueAsBoolean(Node node, String name) {
        String value = EDIConfigDigester.getAttributeValue(node, name);
        if (value == null) {
            return null;
        }
        return Boolean.parseBoolean(value);
    }

    private static Integer getNodeValueAsInteger(Node node, String name) {
        String value = EDIConfigDigester.getAttributeValue(node, name);
        if (value == null) {
            return null;
        }
        return Integer.parseInt(value);
    }

    private static String getAttributeValue(Node node, String name) {
        return node.getAttributes().getNamedItem(name) != null ? node.getAttributes().getNamedItem(name).getNodeValue() : null;
    }

    private static String getNodeValue(Node node, String name) {
        NodeList nodes = node.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node n = nodes.item(i);
            if (!n.getNodeName().equals(name)) continue;
            return n.getTextContent();
        }
        return null;
    }

    private static String retrieveNamespace(Element documentElement, String schemaName) throws EDIConfigurationException {
        NamedNodeMap attributes = documentElement.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node node = attributes.item(i);
            if (!node.getNodeValue().equals(schemaName)) continue;
            String prefix = node.getNodeName();
            if (prefix.startsWith("xmlns:")) {
                return node.getNodeName().replace("xmlns:", "") + NAMESPACE_SUFFIX;
            }
            if (prefix.startsWith("xmlns")) {
                return node.getNodeName().replace("xmlns", "");
            }
            throw new EDIConfigurationException("No namespace exists in edi-message-mapping. A namespace must be declared in order to digest configuration file.");
        }
        return "";
    }
}

