/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.edisax.unedifact;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.milyn.assertion.AssertArgument;
import org.milyn.edisax.BufferedSegmentReader;
import org.milyn.edisax.interchange.ControlBlockHandler;
import org.milyn.edisax.interchange.ControlBlockHandlerFactory;
import org.milyn.edisax.interchange.InterchangeContext;
import org.milyn.edisax.model.internal.Delimiters;
import org.milyn.edisax.unedifact.handlers.r41.UNEdifact41ControlBlockHandlerFactory;
import org.milyn.edisax.unedifact.registry.LazyMappingsRegistry;
import org.milyn.edisax.unedifact.registry.MappingsRegistry;
import org.milyn.namespace.NamespaceResolver;
import org.milyn.xml.hierarchy.HierarchyChangeListener;
import org.milyn.xml.hierarchy.HierarchyChangeReader;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class UNEdifactInterchangeParser
implements XMLReader,
HierarchyChangeReader {
    private Map<String, Boolean> features = new HashMap<String, Boolean>();
    public static final Delimiters defaultUNEdifactDelimiters = new Delimiters().setSegment("'").setField("+").setComponent(":").setEscape("?").setDecimalSeparator(".");
    protected MappingsRegistry registry = new LazyMappingsRegistry();
    private ContentHandler contentHandler;
    private HierarchyChangeListener hierarchyChangeListener;
    private InterchangeContext interchangeContext;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputSource unedifactInterchange) throws IOException, SAXException {
        AssertArgument.isNotNull(unedifactInterchange, "unedifactInterchange");
        if (this.contentHandler == null) {
            throw new IllegalStateException("'contentHandler' not set.  Cannot parse EDI stream.");
        }
        if (this.registry == null) {
            throw new IllegalStateException("'mappingsRegistry' not set.  Cannot parse EDI stream.");
        }
        try {
            String segCode;
            UNEdifact41ControlBlockHandlerFactory handlerFactory = new UNEdifact41ControlBlockHandlerFactory(this.hierarchyChangeListener);
            BufferedSegmentReader segmentReader = new BufferedSegmentReader(unedifactInterchange, defaultUNEdifactDelimiters);
            boolean validate = this.getFeature("http://xml.org/sax/features/validation");
            segmentReader.mark();
            segmentReader.setIgnoreNewLines(this.getFeature("http://xml.org/sax/features/ignore-newlines"));
            NamespaceResolver namespaceResolver = handlerFactory.newNamespaceResolver();
            String envelopePrefix = namespaceResolver.getPrefix(handlerFactory.getNamespace());
            this.contentHandler.startDocument();
            this.contentHandler.startPrefixMapping(envelopePrefix, handlerFactory.getNamespace());
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute("http://www.w3.org/2000/xmlns/", "xmlns:" + envelopePrefix, "xmlns:" + envelopePrefix, "CDATA", handlerFactory.getNamespace());
            this.contentHandler.startElement(handlerFactory.getNamespace(), "unEdifact", envelopePrefix + ":unEdifact", attrs);
            while ((segCode = segmentReader.peek(3, true)).length() == 3) {
                this.interchangeContext = this.createInterchangeContext(segmentReader, validate, handlerFactory, namespaceResolver);
                ControlBlockHandler handler = handlerFactory.getControlBlockHandler(segCode);
                ++this.interchangeContext.indentDepth.value;
                handler.process(this.interchangeContext);
                --this.interchangeContext.indentDepth.value;
            }
            this.contentHandler.characters(new char[]{'\n'}, 0, 1);
            this.contentHandler.endElement(handlerFactory.getNamespace(), "unEdifact", envelopePrefix + ":unEdifact");
            this.contentHandler.endPrefixMapping(envelopePrefix);
            this.contentHandler.endDocument();
        }
        finally {
            this.contentHandler = null;
        }
    }

    protected InterchangeContext createInterchangeContext(BufferedSegmentReader segmentReader, boolean validate, ControlBlockHandlerFactory controlBlockHandlerFactory, NamespaceResolver namespaceResolver) {
        return new InterchangeContext(segmentReader, this.registry, this.contentHandler, controlBlockHandlerFactory, namespaceResolver, validate);
    }

    public InterchangeContext getInterchangeContext() {
        return this.interchangeContext;
    }

    public UNEdifactInterchangeParser setMappingsRegistry(MappingsRegistry registry) {
        AssertArgument.isNotNull(registry, "mappingsRegistry");
        this.registry = registry;
        return this;
    }

    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
    }

    public void ignoreNewLines(boolean ignoreNewLines) {
        this.setFeature("http://xml.org/sax/features/ignore-newlines", ignoreNewLines);
    }

    public void validate(boolean validate) {
        this.setFeature("http://xml.org/sax/features/validation", validate);
    }

    public void setFeature(String name, boolean value) {
        this.features.put(name, value);
    }

    public boolean getFeature(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        Boolean feature = this.features.get(name);
        if (feature == null) {
            return false;
        }
        return feature;
    }

    public void setHierarchyChangeListener(HierarchyChangeListener listener) {
        this.hierarchyChangeListener = listener;
    }

    public void parse(String systemId) throws IOException, SAXException {
        throw new UnsupportedOperationException("Operation not supports by this reader.");
    }

    public DTDHandler getDTDHandler() {
        return null;
    }

    public void setDTDHandler(DTDHandler arg0) {
    }

    public EntityResolver getEntityResolver() {
        return null;
    }

    public void setEntityResolver(EntityResolver arg0) {
    }

    public ErrorHandler getErrorHandler() {
        return null;
    }

    public void setErrorHandler(ErrorHandler arg0) {
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        return null;
    }

    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
    }
}

