/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.edisax.unedifact.handlers;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import org.milyn.edisax.BufferedSegmentReader;
import org.milyn.edisax.EDIParseException;
import org.milyn.edisax.interchange.ControlBlockHandler;
import org.milyn.edisax.interchange.InterchangeContext;
import org.milyn.edisax.model.internal.Segment;
import org.milyn.edisax.util.EDIUtils;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UNBHandler
implements ControlBlockHandler {
    private Segment unbSegment;
    private Segment unzSegment;
    private Map<String, Charset> toCharsetMapping;

    public UNBHandler(Segment unbSegment, Segment unzSegment, HashMap<String, Charset> toCharsetMapping) {
        this.unbSegment = unbSegment;
        this.unzSegment = unzSegment;
        this.toCharsetMapping = toCharsetMapping;
    }

    @Override
    public void process(InterchangeContext interchangeContext) throws IOException, SAXException {
        BufferedSegmentReader segmentReader = interchangeContext.getSegmentReader();
        segmentReader.moveToNextSegment(false);
        String[] fields = segmentReader.getCurrentSegmentFields();
        interchangeContext.mapControlSegment(this.unbSegment, true);
        String[] syntaxIdComponents = EDIUtils.split(fields[1], segmentReader.getDelimiters().getComponent(), segmentReader.getDelimiters().getEscape());
        if (syntaxIdComponents.length < 4) {
            this.changeReadEncoding(syntaxIdComponents[0], interchangeContext.getSegmentReader());
        } else {
            this.changeReadEncoding(syntaxIdComponents[3], interchangeContext.getSegmentReader());
        }
        while (true) {
            String segCode;
            if ((segCode = segmentReader.peek(3, true)).equals("UNZ")) break;
            ControlBlockHandler handler = interchangeContext.getControlBlockHandler(segCode);
            handler.process(interchangeContext);
        }
        segmentReader.moveToNextSegment(false);
        interchangeContext.mapControlSegment(this.unzSegment, true);
    }

    private void changeReadEncoding(String code, BufferedSegmentReader bufferedSegmentReader) throws EDIParseException, IOException {
        Charset charset = this.toCharsetMapping.get(code.toUpperCase());
        if (charset == null) {
            throw new EDIParseException("Unknown UN/EDIFACT character stream encoding code '" + code + "'.");
        }
        bufferedSegmentReader.changeEncoding(charset);
    }
}

