/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.edisax.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

public class NamespaceDeclarationStack {
    private XMLReader xmlReader;
    private final Stack<List<String>> nsStack = new Stack();

    public NamespaceDeclarationStack(XMLReader xmlReader) {
        this.xmlReader = xmlReader;
    }

    public void pop() throws SAXException {
        List<String> pop = this.nsStack.pop();
        Collections.reverse(pop);
        for (String ns : pop) {
            this.xmlReader.getContentHandler().endPrefixMapping(ns);
        }
    }

    public Attributes push(String prefix, String namespace, Attributes attributes) throws SAXException {
        ArrayList<String> namespaces = new ArrayList<String>();
        HashMap<String, String> nsToURI = new HashMap<String, String>();
        AttributesImpl attrs = attributes != null ? new AttributesImpl(attributes) : new AttributesImpl();
        for (int i = 0; i < attrs.getLength(); ++i) {
            String qname = attrs.getQName(i);
            if (qname == null || !qname.startsWith("xmlns:")) continue;
            namespaces.add(attrs.getLocalName(i));
            nsToURI.put(attrs.getLocalName(i), attrs.getValue(i));
        }
        if (!this.prefixAlreadyDeclared(prefix)) {
            attrs.addAttribute("http://www.w3.org/2000/xmlns/", prefix, "xmlns:" + prefix, "CDATA", namespace);
            namespaces.add(prefix);
            nsToURI.put(prefix, namespace);
        }
        this.nsStack.push(namespaces);
        for (String nsPrefix : namespaces) {
            String uri = (String)nsToURI.get(nsPrefix);
            this.xmlReader.getContentHandler().startPrefixMapping(nsPrefix, uri);
        }
        return attrs;
    }

    private boolean prefixAlreadyDeclared(String prefix) {
        for (List list : this.nsStack) {
            if (!list.contains(prefix)) continue;
            return true;
        }
        return false;
    }
}

