/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.javabean.binding;

import java.util.LinkedHashMap;
import java.util.Map;
import org.milyn.assertion.AssertArgument;
import org.milyn.javabean.binding.model.get.Getter;

public class SerializationContext {
    public static final String ROOT_OBJ = SerializationContext.class.getName() + "#ROOT_OBJ";
    private Object rootObject;
    private Map<String, Object> contextObjects = new LinkedHashMap<String, Object>();
    private int currentDepth;

    public SerializationContext(Object rootObject) {
        AssertArgument.isNotNull(rootObject, "rootObject");
        this.rootObject = rootObject;
    }

    public int getCurrentDepth() {
        return this.currentDepth;
    }

    public void incDepth() {
        ++this.currentDepth;
    }

    public void decDepth() {
        --this.currentDepth;
    }

    public void addObject(String name, Object contextObject) {
        this.contextObjects.put(name, contextObject);
    }

    public Object removeObject(String name) {
        return this.contextObjects.remove(name);
    }

    public Object getValue(Getter getter) {
        return getter.get(this.rootObject);
    }

    public Object getValue(String contextObjectName, Getter getter) {
        if (ROOT_OBJ.equals(contextObjectName)) {
            return getter.get(this.rootObject);
        }
        Object contextObject = this.contextObjects.get(contextObjectName);
        if (contextObject == null) {
            throw new IllegalStateException("Unknown context object name '" + contextObjectName + "'.");
        }
        return getter.get(contextObject);
    }
}

