/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.javabean.pojogen;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.milyn.assertion.AssertArgument;
import org.milyn.javabean.pojogen.JNamedType;
import org.milyn.javabean.pojogen.JType;
import org.milyn.javabean.pojogen.PojoGenUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JMethod {
    private JType returnType;
    private String methodName;
    private List<JNamedType> parameters = new ArrayList<JNamedType>();
    private Set<JType> exceptions = new LinkedHashSet<JType>();
    private StringBuilder bodyBuilder = new StringBuilder();

    public JMethod(String methodName) {
        AssertArgument.isNotNull(methodName, "methodName");
        this.returnType = new JType(Void.TYPE);
        this.methodName = methodName;
    }

    public JMethod(JType returnType, String methodName) {
        AssertArgument.isNotNull(returnType, "returnType");
        AssertArgument.isNotNull(methodName, "methodName");
        this.returnType = returnType;
        this.methodName = methodName;
    }

    public JType getReturnType() {
        return this.returnType;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public JMethod addParameter(JType type, String parameterName) {
        return this.addParameter(new JNamedType(type, parameterName));
    }

    public JMethod addParameter(JNamedType parameter) {
        this.parameters.add(parameter);
        return this;
    }

    public List<JNamedType> getParameters() {
        return this.parameters;
    }

    public JMethod appendToBody(String codeString) {
        this.assertNotFinalized();
        this.bodyBuilder.append(codeString);
        return this;
    }

    public int bodyLength() {
        this.assertNotFinalized();
        return this.bodyBuilder.length();
    }

    public String getBody() {
        this.assertNotFinalized();
        return this.bodyBuilder.toString();
    }

    public StringBuilder getBodyBuilder() {
        this.assertNotFinalized();
        return this.bodyBuilder;
    }

    public Set<JType> getExceptions() {
        return this.exceptions;
    }

    public void finalizeMethod() {
        this.assertNotFinalized();
        this.bodyBuilder.setLength(0);
        this.bodyBuilder = null;
    }

    private void assertNotFinalized() {
        if (this.bodyBuilder == null) {
            throw new IllegalStateException("JMethod already finalized.");
        }
    }

    public String getParamSignature() {
        StringBuilder signature = new StringBuilder();
        signature.append("(");
        for (int i = 0; i < this.parameters.size(); ++i) {
            if (i > 0) {
                signature.append(", ");
            }
            signature.append(this.parameters.get(i));
        }
        signature.append(")");
        if (!this.exceptions.isEmpty()) {
            signature.append(PojoGenUtil.getTypeDecl("throws", this.exceptions));
        }
        return signature.toString();
    }
}

