/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.persistence;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.SmooksException;
import org.milyn.cdr.SmooksConfigurationException;
import org.milyn.cdr.annotation.AppContext;
import org.milyn.cdr.annotation.ConfigParam;
import org.milyn.container.ApplicationContext;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.Fragment;
import org.milyn.delivery.annotation.Initialize;
import org.milyn.delivery.annotation.VisitAfterIf;
import org.milyn.delivery.annotation.VisitBeforeIf;
import org.milyn.delivery.dom.DOMElementVisitor;
import org.milyn.delivery.ordering.Consumer;
import org.milyn.delivery.ordering.Producer;
import org.milyn.delivery.sax.SAXElement;
import org.milyn.delivery.sax.SAXVisitAfter;
import org.milyn.delivery.sax.SAXVisitBefore;
import org.milyn.event.report.annotation.VisitAfterReport;
import org.milyn.event.report.annotation.VisitBeforeReport;
import org.milyn.javabean.context.BeanContext;
import org.milyn.javabean.context.BeanIdStore;
import org.milyn.javabean.repository.BeanId;
import org.milyn.persistence.ApplicationContextObjectStore;
import org.milyn.persistence.util.PersistenceUtil;
import org.milyn.scribe.invoker.DaoInvoker;
import org.milyn.scribe.invoker.DaoInvokerFactory;
import org.milyn.scribe.register.DaoRegister;
import org.milyn.util.CollectionsUtil;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@VisitBeforeIf(condition="parameters.containsKey('deleteBefore') && parameters.deleteBefore.value == 'true'")
@VisitAfterIf(condition="!parameters.containsKey('deleteBefore') || parameters.deleteBefore.value != 'true'")
@VisitBeforeReport(summary="Deleting bean under beanId '${resource.parameters.beanId}'.", detailTemplate="reporting/EntityDeleter.html")
@VisitAfterReport(summary="Deleting bean under beanId '${resource.parameters.beanId}'.", detailTemplate="reporting/EntityDeleter.html")
public class EntityDeleter
implements DOMElementVisitor,
SAXVisitBefore,
SAXVisitAfter,
Consumer,
Producer {
    private static Log logger = LogFactory.getLog(EntityDeleter.class);
    @ConfigParam(name="beanId")
    private String beanIdName;
    @ConfigParam(name="deletedBeanId", use=ConfigParam.Use.OPTIONAL)
    private String deletedBeanIdName;
    @ConfigParam(name="dao", use=ConfigParam.Use.OPTIONAL)
    private String daoName;
    @ConfigParam(use=ConfigParam.Use.OPTIONAL)
    private String name;
    @AppContext
    private ApplicationContext appContext;
    private ApplicationContextObjectStore objectStore;
    private BeanId beanId;
    private BeanId deletedBeanId;

    @Initialize
    public void initialize() throws SmooksConfigurationException {
        BeanIdStore beanIdStore = this.appContext.getBeanIdStore();
        this.beanId = beanIdStore.register(this.beanIdName);
        if (this.deletedBeanIdName != null) {
            this.deletedBeanId = beanIdStore.register(this.deletedBeanIdName);
        }
        this.objectStore = new ApplicationContextObjectStore(this.appContext);
    }

    public Set<String> getProducts() {
        if (this.deletedBeanIdName == null) {
            return Collections.emptySet();
        }
        return CollectionsUtil.toSet(this.deletedBeanIdName);
    }

    @Override
    public boolean consumes(Object object) {
        return object.equals(this.beanIdName);
    }

    @Override
    public void visitBefore(Element element, ExecutionContext executionContext) throws SmooksException {
        this.delete(executionContext, new Fragment(element));
    }

    @Override
    public void visitAfter(Element element, ExecutionContext executionContext) throws SmooksException {
        this.delete(executionContext, new Fragment(element));
    }

    @Override
    public void visitBefore(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
        this.delete(executionContext, new Fragment(element));
    }

    @Override
    public void visitAfter(SAXElement element, ExecutionContext executionContext) throws SmooksException, IOException {
        this.delete(executionContext, new Fragment(element));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void delete(ExecutionContext executionContext, Fragment source) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Deleting bean under BeanId '" + this.beanIdName + "' with DAO '" + this.daoName + "'"));
        }
        BeanContext beanContext = executionContext.getBeanContext();
        Object bean = beanContext.getBean(this.beanId);
        DaoRegister<?> emr = PersistenceUtil.getDAORegister(executionContext);
        Object dao = null;
        try {
            Object result;
            dao = this.daoName == null ? (Object)emr.getDefaultDao() : (Object)emr.getDao(this.daoName);
            if (dao == null) {
                String msg = "The DAO register returned null while getting the ";
                msg = this.daoName == null ? msg + "default DAO" : msg + "DAO '" + this.daoName + "'";
                throw new NullPointerException(msg);
            }
            DaoInvoker daoInvoker = DaoInvokerFactory.getInstance().create(dao, this.objectStore);
            Object object = result = this.name != null ? daoInvoker.delete(this.name, bean) : daoInvoker.delete(bean);
            if (this.deletedBeanId != null) {
                if (result == null) {
                    result = bean;
                }
                beanContext.addBean(this.deletedBeanId, result, source);
            } else if (result != null && bean != result) {
                beanContext.changeBean(this.beanId, bean, source);
            }
        }
        finally {
            if (dao != null) {
                emr.returnDao(dao);
            }
        }
    }
}

