/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.persistence.observers;

import org.milyn.container.ExecutionContext;
import org.milyn.javabean.BeanRuntimeInfo;
import org.milyn.javabean.lifecycle.BeanContextLifecycleEvent;
import org.milyn.javabean.lifecycle.BeanContextLifecycleObserver;
import org.milyn.javabean.lifecycle.BeanLifecycle;
import org.milyn.javabean.repository.BeanId;
import org.milyn.persistence.EntityLocatorParameterVisitor;

public class BeanCreateLifecycleObserver
implements BeanContextLifecycleObserver {
    private EntityLocatorParameterVisitor populator;
    private BeanId watchedBean;
    private BeanRuntimeInfo wiredBeanRI;
    private ArrayToListChangeObserver arrayToListChangeObserver;

    public BeanCreateLifecycleObserver(BeanId watchedBean, EntityLocatorParameterVisitor populator, BeanRuntimeInfo wiredBeanRI) {
        this.watchedBean = watchedBean;
        this.populator = populator;
        this.wiredBeanRI = wiredBeanRI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onBeanLifecycleEvent(BeanContextLifecycleEvent event) {
        if (event.getBean() == this.watchedBean) {
            switch (event.getLifecycle()) {
                case ADD: {
                    if (this.wiredBeanRI != null && this.wiredBeanRI.getClassification() == BeanRuntimeInfo.Classification.ARRAY_COLLECTION) {
                        this.arrayToListChangeObserver = new ArrayToListChangeObserver();
                        event.getExecutionContext().getBeanContext().addObserver(this.arrayToListChangeObserver);
                    } else {
                        this.populator.populateAndSetPropertyValue(event.getBean(), event.getExecutionContext());
                    }
                }
                case REMOVE: {
                    try {
                        if (this.arrayToListChangeObserver == null) break;
                        event.getExecutionContext().getBeanContext().removeObserver(this.arrayToListChangeObserver);
                        break;
                    }
                    finally {
                        event.getExecutionContext().getBeanContext().removeObserver(this);
                    }
                }
            }
        }
    }

    class ArrayToListChangeObserver
    implements BeanContextLifecycleObserver {
        ArrayToListChangeObserver() {
        }

        public void onBeanLifecycleEvent(BeanContextLifecycleEvent event) {
            if (event.getBeanId() == BeanCreateLifecycleObserver.this.watchedBean && event.getLifecycle() == BeanLifecycle.CHANGE) {
                ExecutionContext executionContext = event.getExecutionContext();
                BeanCreateLifecycleObserver.this.populator.populateAndSetPropertyValue(event.getBean(), executionContext);
                executionContext.getBeanContext().removeObserver(this);
                BeanCreateLifecycleObserver.this.arrayToListChangeObserver = null;
            }
        }
    }
}

