/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.scribe.register;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.milyn.assertion.AssertArgument;
import org.milyn.scribe.register.AbstractDaoRegister;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapDaoRegister<T>
extends AbstractDaoRegister<T> {
    private final HashMap<String, ? extends T> map;

    public static <T> MapDaoRegister<T> newInstance(Map<String, ? extends T> map) {
        AssertArgument.isNotNull(map, "map");
        return new MapDaoRegister<T>(new HashMap<String, T>(map));
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static <T> Builder<T> builder(Map<String, ? extends T> map) {
        return new Builder<T>(map);
    }

    private MapDaoRegister(HashMap<String, ? extends T> map) {
        this.map = map;
    }

    public boolean containsKey(String key) {
        return this.map.containsKey(key);
    }

    public boolean containsDAO(T dao) {
        return this.map.containsValue(dao);
    }

    public Map<String, T> getAll() {
        return (Map)this.map.clone();
    }

    @Override
    public T getDao(String key) {
        return this.map.get(key);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("daoMap", this.map, true).toString();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MapDaoRegister)) {
            return false;
        }
        MapDaoRegister other = (MapDaoRegister)obj;
        return this.map.equals(other.map);
    }

    public int size() {
        return this.map.size();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder<T> {
        private final HashMap<String, T> map;

        public Builder() {
            this.map = new HashMap();
        }

        public Builder(Map<String, ? extends T> map) {
            AssertArgument.isNotNull(map, "map");
            this.map = new HashMap<String, T>(map);
        }

        public Builder<T> put(String name, T dao) {
            AssertArgument.isNotNull(name, "name");
            AssertArgument.isNotNull(dao, "dao");
            this.map.put(name, dao);
            return this;
        }

        public Builder<T> putAll(Map<String, ? extends T> map) {
            AssertArgument.isNotNull(map, "map");
            this.map.putAll(map);
            return this;
        }

        public MapDaoRegister<T> build() {
            return new MapDaoRegister(this.map);
        }
    }
}

