/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.as7.extension;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.Extension;
import org.jboss.as.controller.ExtensionContext;
import org.jboss.as.controller.OperationHandler;
import org.jboss.as.controller.SubsystemRegistration;
import org.jboss.as.controller.parsing.ExtensionParsingContext;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.controller.registry.ModelNodeRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;
import org.switchyard.as7.extension.Attribute;
import org.switchyard.as7.extension.Element;
import org.switchyard.as7.extension.SwitchYardSubsystemAdd;
import org.switchyard.as7.extension.SwitchYardSubsystemDescribe;
import org.switchyard.as7.extension.SwitchYardSubsystemProviders;

public class SwitchYardExtension
implements Extension {
    public static final String SUBSYSTEM_NAME = "switchyard";
    public static final String NAMESPACE = "urn:jboss:domain:switchyard:1.0";
    private static final SwitchYardSubsystemParser PARSER = new SwitchYardSubsystemParser();

    public void initialize(ExtensionContext context) {
        SubsystemRegistration subsystem = context.registerSubsystem(SUBSYSTEM_NAME);
        ModelNodeRegistration registration = subsystem.registerSubsystemModel(SwitchYardSubsystemProviders.SUBSYSTEM);
        registration.registerOperationHandler("add", (OperationHandler)SwitchYardSubsystemAdd.INSTANCE, SwitchYardSubsystemProviders.SUBSYSTEM_ADD, false);
        registration.registerOperationHandler("describe", (OperationHandler)SwitchYardSubsystemDescribe.INSTANCE, SwitchYardSubsystemProviders.SUBSYSTEM_DESCRIBE, false, OperationEntry.EntryType.PRIVATE);
        subsystem.registerXMLElementWriter((XMLElementWriter)PARSER);
    }

    public void initializeParsers(ExtensionParsingContext context) {
        context.setSubsystemXmlMapping(NAMESPACE, (XMLElementReader)PARSER);
    }

    private static ModelNode createAddSubSystemOperation() {
        ModelNode subsystem = new ModelNode();
        subsystem.get("operation").set("add");
        subsystem.get("address").add("subsystem", SUBSYSTEM_NAME);
        return subsystem;
    }

    static class SwitchYardSubsystemParser
    implements XMLStreamConstants,
    XMLElementReader<List<ModelNode>>,
    XMLElementWriter<SubsystemMarshallingContext> {
        SwitchYardSubsystemParser() {
        }

        public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
            ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
            ModelNode subsytem = SwitchYardExtension.createAddSubSystemOperation();
            block3: while (reader.hasNext() && reader.nextTag() != 2) {
                if (!reader.getNamespaceURI().equals(SwitchYardExtension.NAMESPACE)) continue;
                Element element = Element.forName(reader.getLocalName());
                switch (element) {
                    case MODULES: {
                        ModelNode modules = this.parseModulesElement(reader);
                        if (modules == null) continue block3;
                        subsytem.get("modules").set(modules);
                        continue block3;
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            list.add(subsytem);
        }

        public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
            context.startSubsystemElement(SwitchYardExtension.NAMESPACE, false);
            ModelNode node = context.getModelNode();
            if (this.has(node, "modules")) {
                ModelNode modules = node.get("modules");
                writer.writeStartElement(Element.MODULES.getLocalName());
                Set keys = modules.keys();
                for (String current : keys) {
                    writer.writeEmptyElement(Element.MODULE.getLocalName());
                    writer.writeAttribute(Attribute.IDENTIFIER.getLocalName(), current);
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }

        private boolean has(ModelNode node, String name) {
            return node.has(name) && node.get(name).isDefined();
        }

        ModelNode parseModulesElement(XMLExtendedStreamReader reader) throws XMLStreamException {
            ParseUtils.requireNoAttributes((XMLExtendedStreamReader)reader);
            ModelNode modules = null;
            while (reader.hasNext() && reader.nextTag() != 2) {
                if (!reader.getNamespaceURI().equals(SwitchYardExtension.NAMESPACE)) continue;
                Element element = Element.forName(reader.getLocalName());
                if (element == Element.MODULE) {
                    if (modules == null) {
                        modules = new ModelNode();
                    }
                    String identifier = null;
                    int count = reader.getAttributeCount();
                    block4: for (int i = 0; i < count; ++i) {
                        ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
                        Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                        switch (attribute) {
                            case IDENTIFIER: {
                                identifier = reader.getAttributeValue(i);
                                continue block4;
                            }
                            default: {
                                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                            }
                        }
                    }
                    if (identifier == null) {
                        throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.IDENTIFIER));
                    }
                    if (modules.has(identifier)) {
                        throw new XMLStreamException(element.getLocalName() + " already declared", reader.getLocation());
                    }
                    ModelNode module = new ModelNode();
                    modules.get(identifier).set(module);
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                    continue;
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
            return modules;
        }
    }
}

