/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.config;

import java.io.IOException;
import java.io.StringReader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.switchyard.common.io.resource.ElementResource;
import org.switchyard.common.io.resource.StringResource;
import org.switchyard.common.xml.XMLHelper;
import org.switchyard.config.BaseConfiguration;
import org.switchyard.config.Configuration;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class DOMConfiguration
extends BaseConfiguration {
    private Element _element;
    private Element _parent_element;
    private DOMConfiguration _parent_config;

    DOMConfiguration(Document document) {
        this._element = new ElementResource().pull(document);
    }

    DOMConfiguration(Element element) {
        this(element, true);
    }

    private DOMConfiguration(Element element, boolean normalize) {
        this._element = new ElementResource().pull(element, normalize);
    }

    DOMConfiguration(QName qname) {
        this._element = new ElementResource().pull(qname);
    }

    DOMConfiguration(Configuration from) {
        DOMConfiguration config;
        if (from instanceof DOMConfiguration) {
            config = (DOMConfiguration)from;
        } else {
            Element element = new ElementResource().pull(from.getQName());
            config = new DOMConfiguration(element);
            for (QName qname : from.getAttributeQNames()) {
                config.setAttribute(qname, from.getAttribute(qname));
            }
            for (Configuration grandchild : from.getChildren()) {
                config.addChild(grandchild);
            }
        }
        this._element = config._element;
    }

    @Override
    public String getName() {
        return XMLHelper.nameOf((Node)this._element);
    }

    @Override
    public QName getQName() {
        return XMLHelper.createQName((Element)this._element);
    }

    @Override
    public String getValue() {
        Node text_node = this.getTextNode(false);
        return text_node != null ? text_node.getNodeValue() : null;
    }

    @Override
    public Configuration setValue(String value) {
        if (value != null) {
            Node text_node = this.getTextNode(true);
            text_node.setNodeValue(value);
        } else {
            Node text_node = this.getTextNode(false);
            if (text_node != null) {
                this._element.removeChild(text_node);
            }
        }
        return this;
    }

    private Node getTextNode(boolean create) {
        Node first_child_node = this._element.getFirstChild();
        if (first_child_node != null) {
            if (first_child_node.getNodeType() == 3) {
                return first_child_node;
            }
            for (Node next_child_node = first_child_node.getNextSibling(); next_child_node != null; next_child_node = next_child_node.getNextSibling()) {
                if (next_child_node.getNodeType() != 3) continue;
                return next_child_node;
            }
            if (create) {
                Text text_node = this._element.getOwnerDocument().createTextNode("");
                this._element.insertBefore(text_node, first_child_node);
                return text_node;
            }
        }
        if (create) {
            Text text_node = this._element.getOwnerDocument().createTextNode("");
            this._element.appendChild(text_node);
            return text_node;
        }
        return null;
    }

    @Override
    public List<String> getAttributeNames() {
        ArrayList<String> names = new ArrayList<String>();
        NamedNodeMap attrs = this._element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            String name = XMLHelper.nameOf((Node)attr);
            names.add(name);
        }
        return names;
    }

    @Override
    public List<QName> getAttributeQNames() {
        ArrayList<QName> qnames = new ArrayList<QName>();
        NamedNodeMap attrs = this._element.getAttributes();
        for (int i = 0; i < attrs.getLength(); ++i) {
            Attr attr = (Attr)attrs.item(i);
            String name = XMLHelper.nameOf((Node)attr);
            if (name == null || name.length() <= 0) continue;
            qnames.add(XMLHelper.createQName((String)attr.getNamespaceURI(), (String)name, (String)attr.getPrefix()));
        }
        return qnames;
    }

    @Override
    public boolean hasAttribute(String name) {
        if (name != null) {
            return this._element.hasAttribute(name);
        }
        return false;
    }

    @Override
    public boolean hasAttribute(QName qname) {
        if (qname != null) {
            return this._element.hasAttributeNS(qname.getNamespaceURI(), qname.getLocalPart());
        }
        return false;
    }

    @Override
    public String getAttribute(String name) {
        if (name != null) {
            return this._element.getAttribute(name);
        }
        return null;
    }

    @Override
    public String getAttribute(QName qname) {
        Attr attr;
        if (qname != null && (attr = this._element.getAttributeNodeNS(qname.getNamespaceURI(), qname.getLocalPart())) != null) {
            return attr.getValue();
        }
        return null;
    }

    @Override
    public Configuration setAttribute(String name, String value) {
        if (value == null) {
            this._element.removeAttribute(name);
        } else {
            this._element.setAttribute(name, value);
        }
        return this;
    }

    @Override
    public Configuration setAttribute(QName qname, String value) {
        Attr attr = this._element.getAttributeNodeNS(qname.getNamespaceURI(), qname.getLocalPart());
        if (attr != null) {
            if (value == null) {
                this._element.removeAttributeNode(attr);
            } else {
                attr.setValue(value);
            }
        } else if (value != null && !"http://www.w3.org/2000/xmlns/".equals(qname.getNamespaceURI())) {
            attr = this._element.getOwnerDocument().createAttributeNS(qname.getNamespaceURI(), qname.getLocalPart());
            String prefix = qname.getPrefix();
            if (prefix != null && prefix.length() > 0) {
                attr.setPrefix(prefix);
            }
            attr.setValue(value);
            this._element.setAttributeNode(attr);
        }
        return this;
    }

    @Override
    public boolean hasParent() {
        return this._element.getParentNode() instanceof Element;
    }

    @Override
    public Configuration getParent() {
        Node node = this._element.getParentNode();
        if (node instanceof Element) {
            Element e = (Element)node;
            if (this._parent_element != null && this._parent_element != e) {
                this._parent_config = null;
            }
            if (this._parent_config == null) {
                this._parent_config = new DOMConfiguration(e, false);
                this._parent_element = e;
            }
        }
        return this._parent_config;
    }

    @Override
    public boolean hasChildren() {
        NodeList nodes = this._element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasChildren(String name) {
        if (name != null) {
            NodeList nodes = this._element.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                String node_name;
                Node node = nodes.item(i);
                if (node.getNodeType() != 1 || !(node_name = XMLHelper.nameOf((Node)node)).equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasChildren(QName qname) {
        if (qname != null) {
            NodeList nodes = this._element.getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                QName node_qname;
                Node node = nodes.item(i);
                if (node.getNodeType() != 1 || !(node_qname = XMLHelper.createQName((Element)((Element)node))).equals(qname)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public List<Configuration> getChildren() {
        ArrayList<Configuration> configs = new ArrayList<Configuration>();
        NodeList nodes = this._element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            configs.add(new DOMConfiguration((Element)node));
        }
        return configs;
    }

    @Override
    public List<Configuration> getChildren(String name) {
        ArrayList<Configuration> configs = new ArrayList<Configuration>();
        NodeList nodes = this._element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element element;
            Node node = nodes.item(i);
            if (node.getNodeType() != 1 || !XMLHelper.nameOf((Node)(element = (Element)node)).equals(name)) continue;
            configs.add(new DOMConfiguration(element));
        }
        return configs;
    }

    @Override
    public List<Configuration> getChildrenStartsWith(String name) {
        ArrayList<Configuration> configs = new ArrayList<Configuration>();
        NodeList nodes = this._element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element element;
            Node node = nodes.item(i);
            if (node.getNodeType() != 1 || !XMLHelper.nameOf((Node)(element = (Element)node)).startsWith(name)) continue;
            configs.add(new DOMConfiguration(element));
        }
        return configs;
    }

    @Override
    public List<Configuration> getChildren(QName qname) {
        ArrayList<Configuration> configs = new ArrayList<Configuration>();
        NodeList nodes = this._element.getElementsByTagNameNS(qname.getNamespaceURI(), qname.getLocalPart());
        for (int i = 0; i < nodes.getLength(); ++i) {
            configs.add(new DOMConfiguration((Element)nodes.item(i)));
        }
        return configs;
    }

    @Override
    public Configuration getFirstChild(String name) {
        NodeList nodes = this._element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element element;
            Node node = nodes.item(i);
            if (node.getNodeType() != 1 || !XMLHelper.nameOf((Node)(element = (Element)node)).equals(name)) continue;
            return new DOMConfiguration(element);
        }
        return null;
    }

    @Override
    public Configuration getFirstChildStartsWith(String name) {
        NodeList nodes = this._element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element element;
            Node node = nodes.item(i);
            if (node.getNodeType() != 1 || !XMLHelper.nameOf((Node)(element = (Element)node)).startsWith(name)) continue;
            return new DOMConfiguration(element);
        }
        return null;
    }

    @Override
    public Configuration getFirstChild(QName qname) {
        NodeList nodes = this._element.getElementsByTagNameNS(qname.getNamespaceURI(), qname.getLocalPart());
        if (nodes.getLength() > 0) {
            return new DOMConfiguration((Element)nodes.item(0));
        }
        return null;
    }

    @Override
    public Configuration addChild(Configuration child) {
        DOMConfiguration config = new DOMConfiguration(child);
        this._element.getOwnerDocument().adoptNode(config._element);
        this._element.appendChild(config._element);
        return this;
    }

    @Override
    public Configuration removeChildren() {
        NodeList nodes = this._element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeType() != 1) continue;
            this._element.removeChild(node);
        }
        return this;
    }

    @Override
    public Configuration removeChildren(String name) {
        NodeList nodes = this._element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element element;
            Node node = nodes.item(i);
            if (node.getNodeType() != 1 || !XMLHelper.nameOf((Node)(element = (Element)node)).equals(name)) continue;
            this._element.removeChild(element);
        }
        return this;
    }

    @Override
    public Configuration removeChildren(QName qname) {
        NodeList nodes = this._element.getElementsByTagNameNS(qname.getNamespaceURI(), qname.getLocalPart());
        for (int i = 0; i < nodes.getLength(); ++i) {
            this._element.removeChild(nodes.item(i));
        }
        return this;
    }

    @Override
    public Configuration copy() {
        return new DOMConfiguration((Element)this._element.cloneNode(true), false);
    }

    @Override
    public Configuration normalize() {
        this._element.normalize();
        return this;
    }

    @Override
    public Source getSource() {
        return new DOMSource(this._element);
    }

    @Override
    public void write(Writer writer) throws IOException {
        this.orderChildren();
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            String xsl = (String)new StringResource().pull("/org/switchyard/config/pretty-print.xsl", this.getClass());
            Transformer t = tf.newTransformer(new StreamSource(new StringReader(xsl)));
            t.setOutputProperty("omit-xml-declaration", "yes");
            t.transform(this.getSource(), new StreamResult(writer));
        }
        catch (TransformerException te) {
            throw new IOException(te);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._element == null ? 0 : this._element.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DOMConfiguration other = (DOMConfiguration)obj;
        return !(this._element == null ? other._element != null : !this._element.equals(other._element));
    }
}

