/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.config.model.composite.v1;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.namespace.QName;
import org.switchyard.common.xml.XMLHelper;
import org.switchyard.config.Configuration;
import org.switchyard.config.model.BaseNamedModel;
import org.switchyard.config.model.Descriptor;
import org.switchyard.config.model.composite.BindingModel;
import org.switchyard.config.model.composite.ComponentModel;
import org.switchyard.config.model.composite.CompositeModel;
import org.switchyard.config.model.composite.CompositeServiceModel;
import org.switchyard.config.model.composite.InterfaceModel;

public class V1CompositeServiceModel
extends BaseNamedModel
implements CompositeServiceModel {
    private List<BindingModel> _bindings = new ArrayList<BindingModel>();
    private InterfaceModel _interface;

    public V1CompositeServiceModel() {
        super(new QName("http://docs.oasis-open.org/ns/opencsa/sca/200912", "service"));
    }

    public V1CompositeServiceModel(Configuration config, Descriptor desc) {
        super(config, desc);
        for (Configuration binding_config : config.getChildrenStartsWith("binding")) {
            BindingModel binding = (BindingModel)this.readModel(binding_config);
            if (binding == null) continue;
            this._bindings.add(binding);
        }
    }

    @Override
    public CompositeModel getComposite() {
        return (CompositeModel)this.getModelParent();
    }

    @Override
    public ComponentModel getComponent() {
        QName promote;
        CompositeModel composite = this.getComposite();
        if (composite != null && (promote = this.getPromote()) != null) {
            for (ComponentModel component : composite.getComponents()) {
                if (!promote.equals(component.getQName())) continue;
                return component;
            }
        }
        return null;
    }

    @Override
    public QName getPromote() {
        return XMLHelper.createQName((String)this.getModelAttribute("promote"));
    }

    @Override
    public CompositeServiceModel setPromote(QName promote) {
        this.setModelAttribute("promote", promote != null ? promote.toString() : null);
        return this;
    }

    @Override
    public synchronized List<BindingModel> getBindings() {
        return Collections.unmodifiableList(this._bindings);
    }

    @Override
    public synchronized CompositeServiceModel addBinding(BindingModel binding) {
        this.addChildModel(binding);
        this._bindings.add(binding);
        return this;
    }

    @Override
    public InterfaceModel getInterface() {
        if (this._interface == null) {
            this._interface = (InterfaceModel)this.getFirstChildModelStartsWith("interface");
        }
        return this._interface;
    }

    @Override
    public CompositeServiceModel setInterface(InterfaceModel interfaze) {
        this.setChildModel(interfaze);
        this._interface = interfaze;
        return this;
    }
}

