/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.config.model.domain.v1;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.switchyard.config.Configuration;
import org.switchyard.config.model.BaseNamedModel;
import org.switchyard.config.model.Descriptor;
import org.switchyard.config.model.domain.DomainModel;
import org.switchyard.config.model.domain.PropertyModel;
import org.switchyard.config.model.domain.v1.V1PropertyModel;
import org.switchyard.config.model.switchyard.SwitchYardModel;

public class V1DomainModel
extends BaseNamedModel
implements DomainModel {
    private Map<String, String> _properties = new HashMap<String, String>();

    public V1DomainModel() {
        super(new QName("urn:switchyard-config:domain:1.0", "domain"));
        this.setModelChildrenOrder("property");
    }

    public V1DomainModel(Configuration config, Descriptor desc) {
        super(config, desc);
        for (Configuration property_config : config.getChildren("property")) {
            PropertyModel property = (PropertyModel)this.readModel(property_config);
            if (property == null) continue;
            this._properties.put(property.getName(), property.getValue());
        }
        this.setModelChildrenOrder("property");
    }

    @Override
    public SwitchYardModel getSwitchYard() {
        return (SwitchYardModel)this.getModelParent();
    }

    @Override
    public DomainModel setProperty(String name, String value) {
        PropertyModel property = new V1PropertyModel().setName(name).setValue(value);
        this.addChildModel(property);
        this._properties.put(name, value);
        return this;
    }

    @Override
    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this._properties);
    }

    @Override
    public String getProperty(String name) {
        return this._properties.get(name);
    }
}

