/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.admin.base;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import org.switchyard.admin.Application;
import org.switchyard.admin.ComponentReference;
import org.switchyard.admin.ComponentService;

public class BaseComponentService
implements ComponentService {
    private final QName _name;
    private final String _implementation;
    private final String _interface;
    private final Application _application;
    private List<ComponentReference> _references;
    private final String _implementationConfiguration;

    public BaseComponentService(QName name, String implementation, String implementationConfiguration, String interfaceName, Application application, List<ComponentReference> references) {
        this._name = name;
        this._implementation = implementation;
        this._interface = interfaceName;
        this._application = application;
        if (references != null) {
            this._references = new LinkedList<ComponentReference>(references);
        }
        this._implementationConfiguration = implementationConfiguration;
    }

    @Override
    public QName getName() {
        return this._name;
    }

    @Override
    public String getImplementation() {
        return this._implementation;
    }

    @Override
    public String getInterface() {
        return this._interface;
    }

    @Override
    public List<ComponentReference> getReferences() {
        if (this._references == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this._references);
    }

    @Override
    public Application getApplication() {
        return this._application;
    }

    @Override
    public String getImplementationConfiguration() {
        return this._implementationConfiguration;
    }
}

