/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.config.model;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.validation.Validator;
import org.switchyard.config.Configuration;
import org.switchyard.config.ConfigurationPuller;
import org.switchyard.config.OutputKey;
import org.switchyard.config.model.Descriptor;
import org.switchyard.config.model.Marshaller;
import org.switchyard.config.model.Model;
import org.switchyard.config.model.Validation;

public abstract class BaseModel
implements Model {
    private final Configuration _config;
    private final Descriptor _desc;
    private Model _parent;

    protected BaseModel(QName qname) {
        this(new ConfigurationPuller().pull(qname));
    }

    protected BaseModel(Configuration config) {
        this(config, null);
    }

    protected BaseModel(Configuration config, Descriptor desc) {
        this._config = config;
        this._desc = desc != null ? desc : new Descriptor();
    }

    @Override
    public final Configuration getModelConfiguration() {
        return this._config;
    }

    @Override
    public final Descriptor getModelDescriptor() {
        return this._desc;
    }

    protected final String getModelValue() {
        return this.getModelConfiguration().getValue();
    }

    protected final Model setModelValue(String value) {
        this.getModelConfiguration().setValue(value);
        return this;
    }

    protected final String getModelAttribute(String name) {
        return this.getModelConfiguration().getAttribute(name);
    }

    protected final Model setModelAttribute(String name, String value) {
        this.getModelConfiguration().setAttribute(name, value);
        return this;
    }

    protected final boolean hasParentModel() {
        return this.getModelParent() != null;
    }

    @Override
    public final Model getModelParent() {
        Configuration parent_config;
        if (this._parent == null && (parent_config = this._config.getParent()) != null) {
            this._parent = this.readModel(parent_config);
        }
        return this._parent;
    }

    @Override
    public final List<Model> getModelChildren() {
        ArrayList<Model> child_models = new ArrayList<Model>();
        List<Configuration> child_configs = this._config.getChildren();
        if (child_configs != null) {
            for (Configuration child_config : child_configs) {
                Model child_model;
                if (child_config == null || (child_model = this.readModel(child_config)) == null) continue;
                child_models.add(child_model);
            }
        }
        return child_models;
    }

    @Override
    public Validation validateModel() {
        Validator validator = this._desc.getValidator(this._config);
        if (validator != null) {
            Source source = this._config.getSource();
            try {
                validator.validate(source);
            }
            catch (Throwable t) {
                return new Validation(this.getClass(), t);
            }
        } else {
            return new Validation(this.getClass(), false, "validator == null");
        }
        return new Validation(this.getClass(), true);
    }

    @Override
    public Model assertModelValid() {
        this.validateModel().assertValid();
        return this;
    }

    @Override
    public boolean isModelValid() {
        return this.validateModel().isValid();
    }

    protected final String getModelAttribute(QName qname) {
        return this.getModelConfiguration().getAttribute(qname);
    }

    protected final Model setModelAttribute(QName qname, String value) {
        this.getModelConfiguration().setAttribute(qname, value);
        return this;
    }

    protected final Model getFirstChildModel(String name) {
        Configuration child_config = this._config.getFirstChild(name);
        if (child_config != null) {
            return this.readModel(child_config);
        }
        return null;
    }

    protected final Model getFirstChildModelStartsWith(String name) {
        Configuration child_config = this._config.getFirstChildStartsWith(name);
        if (child_config != null) {
            return this.readModel(child_config);
        }
        return null;
    }

    protected final synchronized Model readModel(Configuration config) {
        Marshaller marsh;
        if (config != null && (marsh = this._desc.getMarshaller(config)) != null) {
            return marsh.read(config);
        }
        return null;
    }

    protected final Model addChildModel(Model child) {
        if (child != null) {
            this._config.addChild(child.getModelConfiguration());
        }
        return this;
    }

    protected final Model setChildModel(Model child) {
        if (child != null) {
            Configuration child_config = child.getModelConfiguration();
            this._config.removeChildren(child_config.getQName());
            this._config.addChild(child_config);
        }
        return this;
    }

    protected final String[] getModelChildrenOrder() {
        return this._config.getChildrenOrder();
    }

    protected final Model setModelChildrenOrder(String ... childrenOrder) {
        this._config.setChildrenOrder(childrenOrder);
        return this;
    }

    @Override
    public Model orderModelChildren() {
        this.primeModelChildren();
        this.getModelConfiguration().orderChildren();
        return this;
    }

    protected final Model primeModelChildren() {
        this.primeModelChildren(this);
        return this;
    }

    private final void primeModelChildren(Model model) {
        for (Model child : model.getModelChildren()) {
            this.primeModelChildren(child);
        }
    }

    @Override
    public void write(OutputStream out, OutputKey ... keys) throws IOException {
        this.getModelConfiguration().write(out, keys);
    }

    @Override
    public void write(Writer writer, OutputKey ... keys) throws IOException {
        this.getModelConfiguration().write(writer, keys);
    }

    public String toString() {
        return this._config.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this._config == null ? 0 : this._config.hashCode());
        result = 31 * result + (this._desc == null ? 0 : this._desc.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BaseModel other = (BaseModel)obj;
        if (this._config == null ? other._config != null : !this._config.equals(other._config)) {
            return false;
        }
        return !(this._desc == null ? other._desc != null : !this._desc.equals(other._desc));
    }
}

