/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.as7.extension;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.switchyard.as7.extension.deployment.SwitchYardCdiIntegrationProcessor;
import org.switchyard.as7.extension.deployment.SwitchYardConfigDeploymentProcessor;
import org.switchyard.as7.extension.deployment.SwitchYardConfigProcessor;
import org.switchyard.as7.extension.deployment.SwitchYardDependencyProcessor;
import org.switchyard.as7.extension.deployment.SwitchYardDeploymentProcessor;
import org.switchyard.as7.extension.services.SwitchYardAdminService;
import org.switchyard.as7.extension.services.SwitchYardServiceDomainManagerService;

public final class SwitchYardSubsystemAdd
extends AbstractBoottimeAddStepHandler {
    private static final Logger LOG = Logger.getLogger((String)"org.switchyard");
    static final SwitchYardSubsystemAdd INSTANCE = new SwitchYardSubsystemAdd();

    private SwitchYardSubsystemAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode submodel) throws OperationFailedException {
        if (operation.has("modules")) {
            submodel.get("modules").set(operation.get("modules"));
        }
    }

    protected void performBoottime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) {
        ModelNode opmodules;
        Set keys;
        final ArrayList<ModuleIdentifier> modules = new ArrayList<ModuleIdentifier>();
        if (operation.has("modules") && (keys = (opmodules = operation.get("modules")).keys()) != null) {
            for (String current : keys) {
                modules.add(ModuleIdentifier.fromString((String)current));
            }
        }
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            protected void execute(DeploymentProcessorTarget processorTarget) {
                int priority = 16384;
                processorTarget.addDeploymentProcessor(Phase.PARSE, priority++, (DeploymentUnitProcessor)new SwitchYardConfigDeploymentProcessor());
                processorTarget.addDeploymentProcessor(Phase.DEPENDENCIES, priority++, (DeploymentUnitProcessor)new SwitchYardDependencyProcessor(modules));
                processorTarget.addDeploymentProcessor(Phase.POST_MODULE, priority++, (DeploymentUnitProcessor)new SwitchYardCdiIntegrationProcessor());
                processorTarget.addDeploymentProcessor(Phase.POST_MODULE, priority++, (DeploymentUnitProcessor)new SwitchYardConfigProcessor());
                processorTarget.addDeploymentProcessor(Phase.INSTALL, priority++, (DeploymentUnitProcessor)new SwitchYardDeploymentProcessor());
            }
        }, OperationContext.Stage.RUNTIME);
        LOG.info((Object)"Activating SwitchYard Extension");
        String version = "0.2.0";
        SwitchYardAdminService adminService = new SwitchYardAdminService("0.2.0");
        newControllers.add(context.getServiceTarget().addService(SwitchYardAdminService.SERVICE_NAME, (Service)adminService).install());
        newControllers.add(context.getServiceTarget().addService(SwitchYardServiceDomainManagerService.SERVICE_NAME, (Service)new SwitchYardServiceDomainManagerService()).install());
    }
}

