/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.as7.extension.admin;

import org.jboss.dmr.ModelNode;
import org.switchyard.admin.Application;
import org.switchyard.admin.Binding;
import org.switchyard.admin.Component;
import org.switchyard.admin.ComponentReference;
import org.switchyard.admin.ComponentService;
import org.switchyard.admin.Service;
import org.switchyard.admin.Transformer;

public final class ModelNodeCreationUtil {
    public static ModelNode createApplicationNode(Application application) {
        ModelNode applicationNode = new ModelNode();
        ModelNode servicesNode = new ModelNode();
        for (Service service : application.getServices()) {
            servicesNode.add(ModelNodeCreationUtil.createServiceNode(service));
        }
        ModelNode componentServicesNode = new ModelNode();
        for (ComponentService componentService : application.getComponentServices()) {
            componentServicesNode.add(ModelNodeCreationUtil.createComopnentServiceNode(componentService));
        }
        ModelNode transformersNode = new ModelNode();
        for (Transformer transformer : application.getTransformers()) {
            transformersNode.add(ModelNodeCreationUtil.createTransformerNode(transformer));
        }
        applicationNode.get("name").set(application.getName().toString());
        applicationNode.get("services").set(servicesNode);
        applicationNode.get("componentServices").set(componentServicesNode);
        applicationNode.get("transformers").set(transformersNode);
        return applicationNode;
    }

    public static ModelNode createServiceNode(Service service) {
        ModelNode serviceNode = new ModelNode();
        serviceNode.get("name").set(service.getName().toString());
        serviceNode.get("application").set(service.getApplication().getName().toString());
        String interfaceName = service.getInterface();
        if (interfaceName == null) {
            serviceNode.get("interface");
        } else {
            serviceNode.get("interface").set(interfaceName);
        }
        ComponentService promotedService = service.getPromotedService();
        if (promotedService == null) {
            serviceNode.get("promotedService");
        } else {
            serviceNode.get("promotedService").set(promotedService.getName().toString());
        }
        ModelNode gatewaysNode = new ModelNode();
        for (Binding gateway : service.getGateways()) {
            gatewaysNode.add(ModelNodeCreationUtil.createGateway(gateway));
        }
        serviceNode.get("gateways").set(gatewaysNode);
        return serviceNode;
    }

    public static ModelNode createComopnentServiceNode(ComponentService service) {
        ModelNode serviceNode = new ModelNode();
        serviceNode.get("name").set(service.getName().toString());
        serviceNode.get("application").set(service.getApplication().getName().toString());
        String interfaceName = service.getInterface();
        if (interfaceName == null) {
            serviceNode.get("interface");
        } else {
            serviceNode.get("interface").set(interfaceName);
        }
        String implementation = service.getImplementation();
        if (implementation == null) {
            serviceNode.get("implementation");
        } else {
            serviceNode.get("implementation").set(implementation);
        }
        String implementationConfiguration = service.getImplementationConfiguration();
        if (implementationConfiguration == null) {
            serviceNode.get("implementationConfiguration");
        } else {
            serviceNode.get("implementationConfiguration").set(implementationConfiguration);
        }
        ModelNode referencesNode = new ModelNode();
        for (ComponentReference reference : service.getReferences()) {
            referencesNode.add(ModelNodeCreationUtil.createComponentReferenceNode(reference));
        }
        serviceNode.get("references").set(referencesNode);
        return serviceNode;
    }

    public static ModelNode createSimpleServiceNode(Service service) {
        ModelNode serviceNode = new ModelNode();
        serviceNode.get("name").set(service.getName().toString());
        serviceNode.get("application").set(service.getApplication().getName().toString());
        return serviceNode;
    }

    public static ModelNode createComponentNode(Component component) {
        ModelNode componentNode = new ModelNode();
        componentNode.get("name").set(component.getName());
        componentNode.get("type").set(component.getType().toString());
        componentNode.get("configSchema").set(component.getConfigSchema());
        return componentNode;
    }

    public static ModelNode createGateway(Binding binding) {
        ModelNode gatewayNode = new ModelNode();
        if (binding.getType() == null) {
            gatewayNode.get("type");
        } else {
            gatewayNode.get("type").set(binding.getType());
        }
        if (binding.getConfiguration() == null) {
            gatewayNode.get("configuration");
        } else {
            gatewayNode.get("configuration").set(binding.getConfiguration());
        }
        return gatewayNode;
    }

    public static ModelNode createComponentReferenceNode(ComponentReference reference) {
        ModelNode referenceNode = new ModelNode();
        if (reference.getName() == null) {
            referenceNode.get("name");
        } else {
            referenceNode.get("name").set(reference.getName().toString());
        }
        if (reference.getInterface() == null) {
            referenceNode.get("interface");
        } else {
            referenceNode.get("interface").set(reference.getInterface());
        }
        return referenceNode;
    }

    public static ModelNode createTransformerNode(Transformer transformation) {
        ModelNode transformationNode = new ModelNode();
        if (transformation.getFrom() == null) {
            transformationNode.get("from");
        } else {
            transformationNode.get("from").set(transformation.getFrom().toString());
        }
        if (transformation.getTo() == null) {
            transformationNode.get("to");
        } else {
            transformationNode.get("to").set(transformation.getTo().toString());
        }
        if (transformation.getType() == null) {
            transformationNode.get("type");
        } else {
            transformationNode.get("type").set(transformation.getType());
        }
        return transformationNode;
    }

    private ModelNodeCreationUtil() {
    }
}

