/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.as7.extension.deployment;

import org.jboss.as.ee.component.Attachments;
import org.jboss.as.ee.component.EEModuleDescription;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.weld.WeldDeploymentMarker;
import org.jboss.as.weld.services.BeanManagerService;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.ImmediateValue;
import org.jboss.msc.value.Value;
import org.switchyard.as7.extension.SwitchYardDeploymentMarker;
import org.switchyard.as7.extension.deployment.SwitchYardDeployment;
import org.switchyard.as7.extension.deployment.SwitchYardMetaData;
import org.switchyard.as7.extension.services.SwitchYardService;
import org.switchyard.as7.extension.services.SwitchYardServiceDomainManagerService;
import org.switchyard.deploy.ServiceDomainManager;

public class SwitchYardDeploymentProcessor
implements DeploymentUnitProcessor {
    private static final Logger LOG = Logger.getLogger((String)"org.switchyard");

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        if (!SwitchYardDeploymentMarker.isSwitchYardDeployment(deploymentUnit)) {
            return;
        }
        LOG.info((Object)("Deploying SwitchYard application '" + deploymentUnit.getName() + "'"));
        ServiceDomainManager domainManager = (ServiceDomainManager)phaseContext.getServiceRegistry().getRequiredService(SwitchYardServiceDomainManagerService.SERVICE_NAME).getService().getValue();
        SwitchYardMetaData metaData = (SwitchYardMetaData)deploymentUnit.getAttachment(SwitchYardMetaData.ATTACHMENT_KEY);
        SwitchYardDeployment deployment = new SwitchYardDeployment(deploymentUnit, metaData.geSwitchYardModel(), domainManager);
        SwitchYardService container = new SwitchYardService(deployment);
        ServiceTarget serviceTarget = phaseContext.getServiceTarget();
        ServiceName switchyardServiceName = deploymentUnit.getServiceName().append(SwitchYardService.SERVICE_NAME);
        ServiceBuilder switchyardServiceBuilder = serviceTarget.addService(switchyardServiceName, (Service)container);
        EEModuleDescription moduleDescription = (EEModuleDescription)deploymentUnit.getAttachment(Attachments.EE_MODULE_DESCRIPTION);
        if (moduleDescription != null) {
            container.getNamespaceSelector().setValue((Value)new ImmediateValue((Object)moduleDescription.getNamespaceContextSelector()));
        }
        if (WeldDeploymentMarker.isPartOfWeldDeployment((DeploymentUnit)deploymentUnit)) {
            ServiceName beanManagerServiceName = deploymentUnit.getServiceName().append(BeanManagerService.NAME);
            switchyardServiceBuilder.addDependency(beanManagerServiceName);
        }
        switchyardServiceBuilder.setInitialMode(ServiceController.Mode.ACTIVE);
        switchyardServiceBuilder.install();
    }

    public void undeploy(DeploymentUnit deploymentUnit) {
    }
}

