/*
 * Decompiled with CFR 0.152.
 */
package org.switchyard.as7.extension.services;

import org.jboss.as.naming.context.NamespaceContextSelector;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.switchyard.admin.base.BaseSwitchYard;
import org.switchyard.admin.base.SwitchYardBuilder;
import org.switchyard.as7.extension.deployment.SwitchYardDeployment;
import org.switchyard.as7.extension.services.SwitchYardAdminService;
import org.switchyard.deploy.internal.DeploymentListener;

public class SwitchYardService
implements Service<SwitchYardDeployment> {
    private static final Logger LOG = Logger.getLogger((String)"org.switchyard");
    public static final ServiceName SERVICE_NAME = ServiceName.of((String[])new String[]{"SwitchYardService"});
    private final InjectedValue<NamespaceContextSelector> _namespaceSelector = new InjectedValue();
    private SwitchYardDeployment _switchyardDeployment;
    private SwitchYardBuilder _switchYardBuilder;

    public SwitchYardService(SwitchYardDeployment switchyardDeployment) {
        this._switchyardDeployment = switchyardDeployment;
    }

    public SwitchYardDeployment getValue() throws IllegalStateException, IllegalArgumentException {
        return null;
    }

    public void start(StartContext context) throws StartException {
        try {
            BaseSwitchYard switchYard;
            NamespaceContextSelector.pushCurrentSelector((NamespaceContextSelector)((NamespaceContextSelector)this._namespaceSelector.getValue()));
            LOG.info((Object)"Starting SwitchYard service");
            ServiceController adminService = context.getController().getServiceContainer().getService(SwitchYardAdminService.SERVICE_NAME);
            if (adminService != null && (switchYard = (BaseSwitchYard)BaseSwitchYard.class.cast(adminService.getValue())) != null) {
                this._switchYardBuilder = new SwitchYardBuilder(switchYard);
                this._switchyardDeployment.setDeploymentListener((DeploymentListener)this._switchYardBuilder);
            }
            this._switchyardDeployment.start();
        }
        catch (Exception e) {
            try {
                this._switchyardDeployment.stop();
            }
            catch (Exception ex) {
                LOG.error((Object)ex);
            }
            throw new StartException((Throwable)e);
        }
        finally {
            NamespaceContextSelector.popCurrentSelector();
        }
    }

    public void stop(StopContext context) {
        this._switchyardDeployment.stop();
        if (this._switchYardBuilder != null) {
            this._switchyardDeployment.removeDeploymentListener((DeploymentListener)this._switchYardBuilder);
            this._switchYardBuilder = null;
        }
    }

    public InjectedValue<NamespaceContextSelector> getNamespaceSelector() {
        return this._namespaceSelector;
    }
}

