/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpmn2.xml;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.drools.core.xml.BaseAbstractHandler;
import org.drools.core.xml.ExtensibleXmlParser;
import org.drools.core.xml.Handler;
import org.jbpm.bpmn2.core.Association;
import org.jbpm.bpmn2.core.Lane;
import org.jbpm.bpmn2.core.SequenceFlow;
import org.jbpm.process.core.context.variable.Variable;
import org.jbpm.ruleflow.core.RuleFlowProcess;
import org.jbpm.workflow.core.Node;
import org.jbpm.workflow.core.NodeContainer;
import org.jbpm.workflow.core.node.CompositeContextNode;
import org.jbpm.workflow.core.node.CompositeNode;
import org.kie.api.definition.process.Process;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class AssociationHandler
extends BaseAbstractHandler
implements Handler {
    public AssociationHandler() {
        if (this.validParents == null && this.validPeers == null) {
            this.validParents = new HashSet();
            this.validParents.add(Process.class);
            this.validParents.add(CompositeContextNode.class);
            this.validPeers = new HashSet();
            this.validPeers.add(null);
            this.validPeers.add(Lane.class);
            this.validPeers.add(Variable.class);
            this.validPeers.add(Node.class);
            this.validPeers.add(SequenceFlow.class);
            this.validPeers.add(Lane.class);
            this.validPeers.add(Association.class);
            this.allowNesting = false;
        }
    }

    public Object start(String uri, String localName, Attributes attrs, ExtensibleXmlParser parser) throws SAXException {
        CompositeContextNode compositeNode;
        parser.startElementBuilder(localName, attrs);
        Association association = new Association();
        association.setId(attrs.getValue("id"));
        association.setSourceRef(attrs.getValue("sourceRef"));
        association.setTargetRef(attrs.getValue("targetRef"));
        String direction = attrs.getValue("associationDirection");
        if (direction != null) {
            String[] possibleDirections;
            boolean acceptableDirection = false;
            direction = direction.toLowerCase();
            for (String acceptable : possibleDirections = new String[]{"none", "one", "both"}) {
                if (!acceptable.equals(direction)) continue;
                acceptableDirection = true;
                break;
            }
            if (!acceptableDirection) {
                throw new IllegalArgumentException("Unknown direction '" + direction + "' used in Association " + association.getId());
            }
        }
        association.setDirection(direction);
        List<Association> associations = null;
        NodeContainer nodeContainer = (NodeContainer)parser.getParent();
        if (nodeContainer instanceof Process) {
            RuleFlowProcess process = (RuleFlowProcess)nodeContainer;
            associations = (List)process.getMetaData("BPMN.Associations");
            if (associations == null) {
                associations = new ArrayList<Association>();
                process.setMetaData("BPMN.Associations", associations);
            }
        } else if (nodeContainer instanceof CompositeNode && (associations = (List)(compositeNode = (CompositeContextNode)nodeContainer).getMetaData("BPMN.Associations")) == null) {
            associations = new ArrayList();
            compositeNode.setMetaData("BPMN.Connections", associations);
        }
        associations.add(association);
        return association;
    }

    public Object end(String uri, String localName, ExtensibleXmlParser parser) throws SAXException {
        parser.endElementBuilder();
        return parser.getCurrent();
    }

    public Class<?> generateNodeFor() {
        return Association.class;
    }
}

