/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.services.task.rule.impl;

import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jbpm.services.task.exception.TaskException;
import org.jbpm.services.task.impl.model.UserImpl;
import org.jbpm.services.task.rule.RuleContextProvider;
import org.jbpm.services.task.rule.TaskRuleService;
import org.jbpm.services.task.rule.TaskServiceRequest;
import org.jbpm.services.task.utils.ContentMarshallerHelper;
import org.kie.api.KieBase;
import org.kie.api.runtime.KieSession;
import org.kie.api.task.model.Task;
import org.kie.internal.task.api.model.ContentData;

@ApplicationScoped
public class TaskRuleServiceImpl
implements TaskRuleService {
    @Inject
    private RuleContextProvider ruleContextProvider;

    @Override
    public void executeRules(Task task, String userId, ContentData contentData, String scope) throws TaskException {
        Object params = ContentMarshallerHelper.unmarshall(contentData.getContent(), null);
        this.executeRules(task, userId, params, scope);
    }

    @Override
    public void executeRules(Task task, String userId, Object params, String scope) throws TaskException {
        KieBase ruleBase = this.ruleContextProvider.getKieBase(scope);
        if (ruleBase != null) {
            KieSession session = ruleBase.newKieSession();
            Map<String, Object> globals = this.ruleContextProvider.getGlobals(scope);
            if (globals != null) {
                for (Map.Entry<String, Object> entry : globals.entrySet()) {
                    session.setGlobal(entry.getKey(), entry.getValue());
                }
            }
            TaskServiceRequest request = new TaskServiceRequest(scope, new UserImpl(userId), null);
            session.setGlobal("request", (Object)request);
            session.insert((Object)task);
            if (params != null) {
                session.insert(params);
            }
            session.fireAllRules();
            if (!request.isAllowed()) {
                StringBuilder error = new StringBuilder("Cannot perform operation " + scope + " :\n");
                if (request.getReasons() != null) {
                    for (String reason : request.getReasons()) {
                        error.append(reason).append('\n');
                    }
                }
                throw request.getException(error.toString());
            }
        }
    }

    public RuleContextProvider getRuleContextProvider() {
        return this.ruleContextProvider;
    }

    public void setRuleContextProvider(RuleContextProvider ruleContextProvider) {
        this.ruleContextProvider = ruleContextProvider;
    }
}

