/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.runtime.manager.impl.tx;

import javax.transaction.Synchronization;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.transaction.UserTransaction;
import org.drools.persistence.TransactionSynchronization;
import org.drools.persistence.TransactionSynchronizationRegistryHelper;
import org.drools.persistence.jta.JtaTransactionManager;
import org.drools.persistence.jta.JtaTransactionSynchronizationAdapter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedJTATransactionManager
extends JtaTransactionManager {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private TransactionManager tm;
    private UserTransaction ut;
    private TransactionSynchronizationRegistry tsr;

    public ExtendedJTATransactionManager(Object ut, Object tsr, Object tm) {
        super(ut, tsr, tm);
        this.ut = ut instanceof UserTransaction ? (UserTransaction)ut : (UserTransaction)(ut != null ? ut : this.findUserTransaction());
        this.tm = tm instanceof TransactionManager ? (TransactionManager)tm : (TransactionManager)(tm != null ? tm : this.findTransactionManager(this.ut));
        this.tsr = (TransactionSynchronizationRegistry)(tsr != null ? tsr : this.findTransactionSynchronizationRegistry(this.ut, this.tm));
    }

    public void registerTransactionSynchronization(TransactionSynchronization ts) {
        if (this.tm != null) {
            try {
                this.tm.getTransaction().registerSynchronization((Synchronization)new JtaTransactionSynchronizationAdapter(ts));
            }
            catch (Exception e) {
                this.logger.warn("Participating in existing JTA transaction, but no JTA TransactionManager or TransactionSychronizationRegistry available: ", (Throwable)e);
            }
        } else if (this.tsr != null) {
            TransactionSynchronizationRegistryHelper.registerTransactionSynchronization((Object)this.tsr, (TransactionSynchronization)ts);
        } else {
            this.logger.warn("Participating in existing JTA transaction, but no JTA TransactionManager or TransactionSychronizationRegistry available: ");
        }
    }
}

