/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.marshalling.impl;

import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.drools.core.WorkingMemoryEntryPoint;
import org.drools.core.base.ClassObjectType;
import org.drools.core.base.DroolsQuery;
import org.drools.core.common.ActivationIterator;
import org.drools.core.common.AgendaItem;
import org.drools.core.common.DefaultAgenda;
import org.drools.core.common.EqualityKey;
import org.drools.core.common.EventFactHandle;
import org.drools.core.common.InternalAgenda;
import org.drools.core.common.InternalAgendaGroup;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalRuleBase;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.InternalWorkingMemoryEntryPoint;
import org.drools.core.common.LogicalDependency;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.NamedEntryPoint;
import org.drools.core.common.ObjectStore;
import org.drools.core.common.WorkingMemoryAction;
import org.drools.core.marshalling.impl.MarshallerWriteContext;
import org.drools.core.marshalling.impl.ProcessMarshaller;
import org.drools.core.marshalling.impl.ProcessMarshallerFactory;
import org.drools.core.marshalling.impl.TimersOutputMarshaller;
import org.drools.core.process.instance.WorkItem;
import org.drools.core.reteoo.AccumulateNode;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.FromNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.QueryElementNode;
import org.drools.core.reteoo.ReteooWorkingMemory;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.reteoo.WindowNode;
import org.drools.core.rule.Behavior;
import org.drools.core.rule.EntryPoint;
import org.drools.core.rule.Rule;
import org.drools.core.rule.SlidingLengthWindow;
import org.drools.core.rule.SlidingTimeWindow;
import org.drools.core.spi.Activation;
import org.drools.core.spi.ActivationGroup;
import org.drools.core.spi.AgendaGroup;
import org.drools.core.spi.PropagationContext;
import org.drools.core.spi.RuleFlowGroup;
import org.drools.core.time.JobContext;
import org.drools.core.time.SelfRemovalJobContext;
import org.drools.core.time.Trigger;
import org.drools.core.time.impl.CronTrigger;
import org.drools.core.time.impl.IntervalTrigger;
import org.drools.core.time.impl.PointInTimeTrigger;
import org.drools.core.time.impl.PseudoClockScheduler;
import org.drools.core.time.impl.TimerJobInstance;
import org.drools.core.util.LinkedList;
import org.drools.core.util.ObjectHashMap;
import org.drools.core.util.ObjectHashSet;
import org.kie.api.marshalling.ObjectMarshallingStrategy;
import org.kie.api.marshalling.ObjectMarshallingStrategyStore;

public class OutputMarshaller {
    private static ProcessMarshaller processMarshaller = OutputMarshaller.createProcessMarshaller();

    private static ProcessMarshaller createProcessMarshaller() {
        try {
            return ProcessMarshallerFactory.newProcessMarshaller();
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static void writeSession(MarshallerWriteContext context) throws IOException {
        ReteooWorkingMemory wm = (ReteooWorkingMemory)context.wm;
        wm.getAgenda().unstageActivations();
        context.writeBoolean(false);
        long time = 0L;
        if (context.wm.getTimerService() instanceof PseudoClockScheduler) {
            time = context.clockTime;
        }
        context.writeLong(time);
        context.writeInt(wm.getFactHandleFactory().getId());
        context.writeLong(wm.getFactHandleFactory().getRecency());
        context.writeLong(wm.getPropagationIdCounter());
        InternalFactHandle handle = context.wm.getInitialFactHandle();
        context.writeInt(handle.getId());
        context.writeLong(handle.getRecency());
        OutputMarshaller.writeAgenda(context);
        OutputMarshaller.writeInitialFactHandleRightTuples(context);
        for (WorkingMemoryEntryPoint wmep : wm.getEntryPoints().values()) {
            context.stream.writeShort(90);
            context.stream.writeUTF(wmep.getEntryPointId());
            OutputMarshaller.writeFactHandles(context, ((NamedEntryPoint)wmep).getObjectStore());
        }
        context.stream.writeShort(1);
        OutputMarshaller.writeInitialFactHandleLeftTuples(context);
        OutputMarshaller.writePropagationContexts(context);
        OutputMarshaller.writeActivations(context);
        OutputMarshaller.writeActionQueue(context);
        OutputMarshaller.writeTruthMaintenanceSystem(context);
        if (context.marshalProcessInstances && processMarshaller != null) {
            processMarshaller.writeProcessInstances(context);
        } else {
            context.stream.writeShort(1);
        }
        if (context.marshalWorkItems && processMarshaller != null) {
            processMarshaller.writeWorkItems(context);
        } else {
            context.stream.writeShort(1);
        }
        if (processMarshaller != null) {
            processMarshaller.writeProcessTimers(context);
        } else {
            context.stream.writeShort(1);
        }
        OutputMarshaller.writeTimers(context.wm.getTimerService().getTimerJobInstances(context.wm.getId()), context);
    }

    public static void writeAgenda(MarshallerWriteContext context) throws IOException {
        InternalWorkingMemory wm = context.wm;
        DefaultAgenda agenda = (DefaultAgenda)wm.getAgenda();
        Map<String, ActivationGroup> activationGroups = agenda.getActivationGroupsMap();
        InternalAgendaGroup[] agendaGroups = agenda.getAgendaGroupsMap().values().toArray(new InternalAgendaGroup[agenda.getAgendaGroupsMap().size()]);
        Arrays.sort(agendaGroups, AgendaGroupSorter.instance);
        for (InternalAgendaGroup group : agendaGroups) {
            context.writeShort(13);
            context.writeUTF(group.getName());
            context.writeBoolean(group.isActive());
            context.writeLong(group.getActivatedForRecency());
        }
        context.writeShort(1);
        java.util.LinkedList<AgendaGroup> focusStack = agenda.getStackList();
        for (AgendaGroup group : focusStack) {
            context.writeShort(13);
            context.writeUTF(group.getName());
        }
        context.writeShort(1);
        context.writeShort(1);
    }

    public static void writeActionQueue(MarshallerWriteContext context) throws IOException {
        ReteooWorkingMemory wm = (ReteooWorkingMemory)context.wm;
        WorkingMemoryAction[] queue = wm.getActionQueue().toArray(new WorkingMemoryAction[wm.getActionQueue().size()]);
        for (int i = queue.length - 1; i >= 0; --i) {
            context.writeShort(10);
            queue[i].write(context);
        }
        context.writeShort(1);
    }

    public static void writeTruthMaintenanceSystem(MarshallerWriteContext context) throws IOException {
        MarshallerWriteContext stream = context.stream;
        throw new UnsupportedOperationException();
    }

    public static void writeFactHandles(MarshallerWriteContext context, ObjectStore objectStore) throws IOException {
        MarshallerWriteContext stream = context.stream;
        InternalWorkingMemory wm = context.wm;
        ObjectMarshallingStrategyStore objectMarshallingStrategyStore = context.objectMarshallingStrategyStore;
        ArrayList<InternalFactHandle> matchFactHandles = null;
        if (((InternalAgenda)wm.getAgenda()).isDeclarativeAgenda()) {
            org.drools.core.util.Iterator it = ActivationIterator.iterator(wm);
            matchFactHandles = new ArrayList<InternalFactHandle>(100);
            Activation item = (Activation)it.next();
            while (item != null) {
                matchFactHandles.add(item.getFactHandle());
                item = (Activation)it.next();
            }
        }
        stream.writeInt(objectStore.size() + (matchFactHandles == null ? 0 : matchFactHandles.size()));
        for (InternalFactHandle handle : OutputMarshaller.orderFacts(objectStore)) {
            OutputMarshaller.writeFactHandle(context, stream, objectMarshallingStrategyStore, handle);
            OutputMarshaller.writeRightTuples(handle, context);
        }
        if (matchFactHandles != null) {
            for (InternalFactHandle handle : OutputMarshaller.orderFacts(matchFactHandles)) {
                Object object = handle.getObject();
                handle.setObject(null);
                OutputMarshaller.writeFactHandle(context, stream, objectMarshallingStrategyStore, handle);
                handle.setObject(object);
                OutputMarshaller.writeRightTuples(handle, context);
            }
        }
        OutputMarshaller.writeLeftTuples(context, OutputMarshaller.orderFacts(objectStore));
        if (matchFactHandles != null) {
            stream.writeBoolean(true);
            OutputMarshaller.writeLeftTuples(context, OutputMarshaller.orderFacts(matchFactHandles));
        } else {
            stream.writeBoolean(false);
        }
    }

    private static void writeFactHandle(MarshallerWriteContext context, ObjectOutputStream stream, ObjectMarshallingStrategyStore objectMarshallingStrategyStore, int type, InternalFactHandle handle) throws IOException {
        stream.writeInt(type);
        stream.writeInt(handle.getId());
        stream.writeLong(handle.getRecency());
        if (type == 2) {
            EventFactHandle efh = (EventFactHandle)handle;
            stream.writeLong(efh.getStartTimestamp());
            stream.writeLong(efh.getDuration());
            stream.writeBoolean(efh.isExpired());
            stream.writeLong(efh.getActivationsCount());
        }
        Object object = handle.getObject();
        stream.writeInt(-2);
        if (object != null) {
            ObjectMarshallingStrategy strategy = objectMarshallingStrategyStore.getStrategyObject(object);
            String strategyClassName = strategy.getClass().getName();
            stream.writeUTF(strategyClassName);
            strategy.write(stream, object);
        } else {
            stream.writeUTF("");
        }
        if (handle.getEntryPoint() instanceof InternalWorkingMemoryEntryPoint) {
            String entryPoint = ((InternalWorkingMemoryEntryPoint)handle.getEntryPoint()).getEntryPoint().getEntryPointId();
            if (entryPoint != null && !entryPoint.equals("")) {
                stream.writeBoolean(true);
                stream.writeUTF(entryPoint);
            } else {
                stream.writeBoolean(false);
            }
        } else {
            stream.writeBoolean(false);
        }
    }

    private static void writeFactHandle(MarshallerWriteContext context, ObjectOutputStream stream, ObjectMarshallingStrategyStore objectMarshallingStrategyStore, InternalFactHandle handle) throws IOException {
        OutputMarshaller.writeFactHandle(context, stream, objectMarshallingStrategyStore, handle instanceof EventFactHandle ? 2 : 0, handle);
    }

    public static InternalFactHandle[] orderFacts(ObjectStore objectStore) {
        int size = objectStore.size();
        InternalFactHandle[] handles = new InternalFactHandle[size];
        int i = 0;
        Iterator it = objectStore.iterateFactHandles();
        while (it.hasNext()) {
            handles[i++] = (InternalFactHandle)it.next();
        }
        Arrays.sort(handles, new HandleSorter());
        return handles;
    }

    public static InternalFactHandle[] orderFacts(List<InternalFactHandle> handlesList) {
        int size = handlesList.size();
        InternalFactHandle[] handles = handlesList.toArray(new InternalFactHandle[size]);
        Arrays.sort(handles, new HandleSorter());
        return handles;
    }

    public static void writeInitialFactHandleRightTuples(MarshallerWriteContext context) throws IOException {
        MarshallerWriteContext stream = context.stream;
        InternalRuleBase ruleBase = context.ruleBase;
        ObjectTypeNode initialFactNode = ruleBase.getRete().getEntryPointNode(EntryPoint.DEFAULT).getObjectTypeNodes().get(ClassObjectType.InitialFact_ObjectType);
        if (initialFactNode != null) {
            ObjectHashSet initialFactMemory = (ObjectHashSet)((Object)context.wm.getNodeMemory(initialFactNode));
            if (initialFactMemory != null && !initialFactMemory.isEmpty()) {
                stream.writeBoolean(true);
                stream.writeInt(initialFactNode.getId());
                OutputMarshaller.writeRightTuples(context.wm.getInitialFactHandle(), context);
            } else {
                stream.writeBoolean(false);
            }
        } else {
            stream.writeBoolean(false);
        }
    }

    public static void writeInitialFactHandleLeftTuples(MarshallerWriteContext context) throws IOException {
        MarshallerWriteContext stream = context.stream;
        InternalFactHandle handle = context.wm.getInitialFactHandle();
        for (LeftTuple leftTuple = handle.getFirstLeftTuple(); leftTuple != null; leftTuple = leftTuple.getLeftParentNext()) {
            stream.writeShort(3);
            stream.writeInt(leftTuple.getLeftTupleSink().getId());
            OutputMarshaller.writeLeftTuple(leftTuple, context, true);
        }
        stream.writeShort(1);
    }

    public static void writeRightTuples(InternalFactHandle handle, MarshallerWriteContext context) throws IOException {
        MarshallerWriteContext stream = context.stream;
        for (RightTuple rightTuple = handle.getFirstRightTuple(); rightTuple != null; rightTuple = rightTuple.getHandleNext()) {
            stream.writeShort(4);
            OutputMarshaller.writeRightTuple(rightTuple, context);
        }
        stream.writeShort(1);
    }

    public static void writeRightTuple(RightTuple rightTuple, MarshallerWriteContext context) throws IOException {
        MarshallerWriteContext stream = context.stream;
        InternalWorkingMemory wm = context.wm;
        int id = rightTuple.getRightTupleSink() != null ? rightTuple.getRightTupleSink().getId() : -1;
        stream.writeInt(id);
    }

    public static void writeLeftTuples(MarshallerWriteContext context, InternalFactHandle[] factHandles) throws IOException {
        MarshallerWriteContext stream = context.stream;
        InternalWorkingMemory wm = context.wm;
        for (InternalFactHandle handle : factHandles) {
            for (LeftTuple leftTuple = handle.getFirstLeftTuple(); leftTuple != null; leftTuple = leftTuple.getLeftParentNext()) {
                stream.writeShort(3);
                int sinkId = leftTuple.getLeftTupleSink().getId();
                stream.writeInt(sinkId);
                stream.writeInt(handle.getId());
                OutputMarshaller.writeLeftTuple(leftTuple, context, true);
            }
        }
        stream.writeShort(1);
    }

    public static void writeLeftTuple(LeftTuple leftTuple, MarshallerWriteContext context, boolean recurse) throws IOException {
        MarshallerWriteContext stream = context.stream;
        InternalRuleBase ruleBase = context.ruleBase;
        InternalWorkingMemory wm = context.wm;
        LeftTupleSink sink = leftTuple.getLeftTupleSink();
        switch (sink.getType()) {
            case 181: {
                for (LeftTuple childLeftTuple = leftTuple.getFirstChild(); childLeftTuple != null; childLeftTuple = childLeftTuple.getLeftParentNext()) {
                    stream.writeShort(4);
                    int childSinkId = childLeftTuple.getLeftTupleSink().getId();
                    stream.writeInt(childSinkId);
                    stream.writeInt(childLeftTuple.getRightParent().getFactHandle().getId());
                    OutputMarshaller.writeLeftTuple(childLeftTuple, context, recurse);
                }
                stream.writeShort(1);
                break;
            }
            case 131: 
            case 141: {
                for (LeftTuple childLeftTuple = leftTuple.getFirstChild(); childLeftTuple != null; childLeftTuple = childLeftTuple.getLeftParentNext()) {
                    stream.writeShort(3);
                    stream.writeInt(childLeftTuple.getLeftTupleSink().getId());
                    OutputMarshaller.writeLeftTuple(childLeftTuple, context, recurse);
                }
                stream.writeShort(1);
                break;
            }
            case 191: 
            case 221: {
                if (leftTuple.getBlocker() == null) {
                    stream.writeShort(7);
                    for (LeftTuple childLeftTuple = leftTuple.getFirstChild(); childLeftTuple != null; childLeftTuple = childLeftTuple.getLeftParentNext()) {
                        stream.writeShort(3);
                        stream.writeInt(childLeftTuple.getLeftTupleSink().getId());
                        OutputMarshaller.writeLeftTuple(childLeftTuple, context, recurse);
                    }
                    stream.writeShort(1);
                    break;
                }
                stream.writeShort(6);
                stream.writeInt(leftTuple.getBlocker().getFactHandle().getId());
                break;
            }
            case 201: {
                if (leftTuple.getBlocker() == null) {
                    stream.writeShort(7);
                    break;
                }
                stream.writeShort(6);
                stream.writeInt(leftTuple.getBlocker().getFactHandle().getId());
                for (LeftTuple childLeftTuple = leftTuple.getFirstChild(); childLeftTuple != null; childLeftTuple = childLeftTuple.getLeftParentNext()) {
                    stream.writeShort(3);
                    stream.writeInt(childLeftTuple.getLeftTupleSink().getId());
                    OutputMarshaller.writeLeftTuple(childLeftTuple, context, recurse);
                }
                stream.writeShort(1);
                break;
            }
            case 211: {
                AccumulateNode.AccumulateMemory memory = (AccumulateNode.AccumulateMemory)context.wm.getNodeMemory((BetaNode)sink);
                AccumulateNode.AccumulateContext accctx = (AccumulateNode.AccumulateContext)leftTuple.getObject();
                OutputMarshaller.writeFactHandle(context, stream, context.objectMarshallingStrategyStore, accctx.result.getFactHandle());
                stream.writeObject(accctx.context);
                stream.writeBoolean(accctx.propagated);
                for (LeftTuple childLeftTuple = leftTuple.getFirstChild(); childLeftTuple != null; childLeftTuple = childLeftTuple.getLeftParentNext()) {
                    if (leftTuple.getLeftTupleSink().getId() == childLeftTuple.getLeftTupleSink().getId()) {
                        stream.writeShort(4);
                        stream.writeInt(childLeftTuple.getRightParent().getFactHandle().getId());
                        continue;
                    }
                    stream.writeShort(3);
                    int sinkId = childLeftTuple.getLeftTupleSink().getId();
                    stream.writeInt(sinkId);
                    OutputMarshaller.writeLeftTuple(childLeftTuple, context, recurse);
                }
                stream.writeShort(1);
                break;
            }
            case 71: {
                ObjectHashMap memory = (ObjectHashMap)((Object)context.wm.getNodeMemory((MemoryFactory)((Object)sink)));
                InternalFactHandle ifh = (InternalFactHandle)memory.get(leftTuple);
                stream.writeInt(ifh.getId());
                stream.writeLong(ifh.getRecency());
                OutputMarshaller.writeRightTuples(ifh, context);
                stream.writeShort(1);
                break;
            }
            case 151: {
                FromNode.FromMemory memory = (FromNode.FromMemory)context.wm.getNodeMemory((MemoryFactory)((Object)sink));
                Map matches = (Map)leftTuple.getObject();
                for (RightTuple rightTuples : matches.values()) {
                    stream.writeShort(2);
                    OutputMarshaller.writeFactHandle(context, stream, context.objectMarshallingStrategyStore, rightTuples.getFactHandle());
                    OutputMarshaller.writeRightTuples(rightTuples.getFactHandle(), context);
                }
                stream.writeShort(1);
                for (LeftTuple childLeftTuple = leftTuple.getFirstChild(); childLeftTuple != null; childLeftTuple = childLeftTuple.getLeftParentNext()) {
                    stream.writeShort(4);
                    stream.writeInt(childLeftTuple.getLeftTupleSink().getId());
                    stream.writeInt(childLeftTuple.getRightParent().getFactHandle().getId());
                    OutputMarshaller.writeLeftTuple(childLeftTuple, context, recurse);
                }
                stream.writeShort(1);
                break;
            }
            case 165: {
                QueryElementNode node = (QueryElementNode)sink;
                boolean isOpen = node.isOpenQuery();
                context.writeBoolean(isOpen);
                if (isOpen) {
                    InternalFactHandle factHandle = (InternalFactHandle)leftTuple.getObject();
                    DroolsQuery query = (DroolsQuery)factHandle.getObject();
                    factHandle.setObject(null);
                    OutputMarshaller.writeFactHandle(context, stream, context.objectMarshallingStrategyStore, 0, factHandle);
                    factHandle.setObject(query);
                    OutputMarshaller.writeLeftTuples(context, new InternalFactHandle[]{factHandle});
                    break;
                }
                for (LeftTuple childLeftTuple = leftTuple.getFirstChild(); childLeftTuple != null; childLeftTuple = childLeftTuple.getLeftParentNext()) {
                    stream.writeShort(3);
                    stream.writeInt(childLeftTuple.getLeftTupleSink().getId());
                    InternalFactHandle factHandle = childLeftTuple.getLastHandle();
                    OutputMarshaller.writeFactHandle(context, stream, context.objectMarshallingStrategyStore, 1, factHandle);
                    OutputMarshaller.writeLeftTuple(childLeftTuple, context, recurse);
                }
                stream.writeShort(1);
                break;
            }
            case 101: {
                int pos = context.terminalTupleMap.size();
                context.terminalTupleMap.put(leftTuple, pos);
                break;
            }
            case 91: {
                context.writeBoolean(true);
                RightTuple rightTuple = (RightTuple)leftTuple.getObject();
                OutputMarshaller.writeFactHandle(context, stream, context.objectMarshallingStrategyStore, 1, rightTuple.getFactHandle());
                for (LeftTuple childLeftTuple = rightTuple.firstChild; childLeftTuple != null; childLeftTuple = childLeftTuple.getRightParentNext()) {
                    stream.writeShort(3);
                    stream.writeInt(childLeftTuple.getLeftTupleSink().getId());
                    OutputMarshaller.writeLeftTuple(childLeftTuple, context, recurse);
                }
                stream.writeShort(1);
                break;
            }
        }
    }

    public static void writeBehaviours(WindowNode windowNode, MarshallerWriteContext outCtx) throws IOException {
        Behavior[] behaviors = windowNode.getBehaviors();
        WindowNode.WindowMemory memory = (WindowNode.WindowMemory)outCtx.wm.getNodeMemory(windowNode);
        Object[] behaviorContexts = (Object[])memory.behaviorContext;
        for (int i = 0; i < behaviors.length; ++i) {
            if (windowNode.getBehaviors()[i] instanceof SlidingTimeWindow) {
                outCtx.writeShort(100);
                outCtx.writeInt(i);
                OutputMarshaller.writeSlidingTimeWindowBehaviour((SlidingTimeWindow)windowNode.getBehaviors()[i], (SlidingTimeWindow.SlidingTimeWindowContext)behaviorContexts[i], outCtx);
                continue;
            }
            if (!(windowNode.getBehaviors()[i] instanceof SlidingLengthWindow)) continue;
            outCtx.writeShort(101);
            outCtx.writeInt(i);
            OutputMarshaller.writeSlidingLengthWindowBehaviour((SlidingLengthWindow)windowNode.getBehaviors()[i], (SlidingLengthWindow.SlidingLengthWindowContext)behaviorContexts[i], outCtx);
        }
        outCtx.writeShort(1);
    }

    public static void writeSlidingTimeWindowBehaviour(SlidingTimeWindow stw, SlidingTimeWindow.SlidingTimeWindowContext slCtx, MarshallerWriteContext outputCtx) throws IOException {
    }

    public static void writeSlidingLengthWindowBehaviour(SlidingLengthWindow stw, SlidingLengthWindow.SlidingLengthWindowContext slCtx, MarshallerWriteContext outputCtx) throws IOException {
    }

    public static void writeActivations(MarshallerWriteContext context) throws IOException {
        MarshallerWriteContext stream = context.stream;
        Map.Entry[] entries = context.terminalTupleMap.entrySet().toArray(new Map.Entry[context.terminalTupleMap.size()]);
        Arrays.sort(entries, TupleSorter.instance);
        if (entries.length != 0) {
            for (Map.Entry entry : entries) {
                if (((LeftTuple)entry.getKey()).getObject() == null) continue;
                LeftTuple leftTuple = (LeftTuple)entry.getKey();
                stream.writeShort(8);
                OutputMarshaller.writeActivation(context, leftTuple, (AgendaItem)leftTuple.getObject(), (RuleTerminalNode)leftTuple.getLeftTupleSink());
            }
        }
        stream.writeShort(1);
    }

    public static void writeActivation(MarshallerWriteContext context, LeftTuple leftTuple, AgendaItem agendaItem, RuleTerminalNode ruleTerminalNode) throws IOException {
        MarshallerWriteContext stream = context.stream;
        stream.writeLong(agendaItem.getActivationNumber());
        stream.writeInt(context.terminalTupleMap.get(leftTuple));
        stream.writeInt(agendaItem.getSalience());
        Rule rule = agendaItem.getRule();
        stream.writeUTF(rule.getPackage());
        stream.writeUTF(rule.getName());
        stream.writeLong(agendaItem.getPropagationContext().getPropagationNumber());
        if (agendaItem.getActivationGroupNode() != null) {
            stream.writeBoolean(true);
            stream.writeUTF(agendaItem.getActivationGroupNode().getActivationGroup().getName());
        } else {
            stream.writeBoolean(false);
        }
        stream.writeBoolean(agendaItem.isQueued());
        if (agendaItem.getFactHandle() != null) {
            stream.writeBoolean(true);
            stream.writeInt(agendaItem.getFactHandle().getId());
        } else {
            stream.writeBoolean(false);
        }
        LinkedList<LogicalDependency> list = agendaItem.getLogicalDependencies();
        if (list != null && !list.isEmpty()) {
            for (LogicalDependency node = list.getFirst(); node != null; node = (LogicalDependency)node.getNext()) {
                stream.writeShort(12);
                stream.writeInt(((InternalFactHandle)node.getJustified()).getId());
            }
        }
        stream.writeShort(1);
    }

    public static void writePropagationContexts(MarshallerWriteContext context) throws IOException {
        MarshallerWriteContext stream = context.stream;
        if (context.terminalTupleMap != null && context.terminalTupleMap.size() > 0) {
            Map.Entry[] entries = context.terminalTupleMap.entrySet().toArray(new Map.Entry[context.terminalTupleMap.size()]);
            Arrays.sort(entries, TupleSorter.instance);
            if (entries.length != 0) {
                HashMap<Long, PropagationContext> pcMap = new HashMap<Long, PropagationContext>();
                for (Map.Entry entry : entries) {
                    PropagationContext pc;
                    LeftTuple leftTuple = (LeftTuple)entry.getKey();
                    if (leftTuple.getObject() == null || pcMap.containsKey((pc = ((Activation)leftTuple.getObject()).getPropagationContext()).getPropagationNumber())) continue;
                    stream.writeShort(9);
                    OutputMarshaller.writePropagationContext(context, pc);
                    pcMap.put(pc.getPropagationNumber(), pc);
                }
            }
        }
        stream.writeShort(1);
    }

    public static void writePropagationContext(MarshallerWriteContext context, PropagationContext pc) throws IOException {
        MarshallerWriteContext stream = context.stream;
        Map<LeftTuple, Integer> tuples = context.terminalTupleMap;
        stream.writeInt(pc.getType());
        Rule ruleOrigin = pc.getRuleOrigin();
        if (ruleOrigin != null) {
            stream.writeBoolean(true);
            stream.writeUTF(ruleOrigin.getPackage());
            stream.writeUTF(ruleOrigin.getName());
        } else {
            stream.writeBoolean(false);
        }
        LeftTuple tupleOrigin = pc.getLeftTupleOrigin();
        if (tupleOrigin != null && tuples.containsKey(tupleOrigin)) {
            stream.writeBoolean(true);
            stream.writeInt(tuples.get(tupleOrigin));
        } else {
            stream.writeBoolean(false);
        }
        stream.writeLong(pc.getPropagationNumber());
        if (pc.getFactHandleOrigin() != null) {
            stream.writeInt(((InternalFactHandle)pc.getFactHandleOrigin()).getId());
        } else {
            stream.writeInt(-1);
        }
        stream.writeUTF(pc.getEntryPoint().getEntryPointId());
    }

    public static void writeWorkItem(MarshallerWriteContext context, WorkItem workItem) throws IOException {
        MarshallerWriteContext stream = context.stream;
        stream.writeLong(workItem.getId());
        stream.writeLong(workItem.getProcessInstanceId());
        stream.writeUTF(workItem.getName());
        stream.writeInt(workItem.getState());
        Map parameters = workItem.getParameters();
        ArrayList notNullValues = new ArrayList();
        for (Object value : parameters.values()) {
            if (value == null) continue;
            notNullValues.add(value);
        }
        stream.writeInt(notNullValues.size());
        for (String key : parameters.keySet()) {
            Object object = parameters.get(key);
            if (object == null) continue;
            stream.writeUTF(key);
            ObjectMarshallingStrategy strategy = context.objectMarshallingStrategyStore.getStrategyObject(object);
            String strategyClassName = strategy.getClass().getName();
            stream.writeInt(-2);
            stream.writeUTF(strategyClassName);
            if (!strategy.accept(object)) continue;
            strategy.write((ObjectOutputStream)stream, object);
        }
    }

    public static void writeTimers(Collection<TimerJobInstance> timers, MarshallerWriteContext outCtx) throws IOException {
        ArrayList<TimerJobInstance> sortedTimers = new ArrayList<TimerJobInstance>(timers);
        Collections.sort(sortedTimers, new Comparator<TimerJobInstance>(){

            @Override
            public int compare(TimerJobInstance o1, TimerJobInstance o2) {
                return (int)(o1.getJobHandle().getId() - o2.getJobHandle().getId());
            }
        });
        for (TimerJobInstance timer : sortedTimers) {
            outCtx.writeShort(50);
            JobContext jctx = ((SelfRemovalJobContext)timer.getJobContext()).getJobContext();
            TimersOutputMarshaller writer = outCtx.writersByClass.get(jctx.getClass());
            writer.write(jctx, outCtx);
        }
        outCtx.writeShort(1);
    }

    public static void writeTrigger(Trigger trigger, MarshallerWriteContext outCtx) throws IOException {
        if (trigger instanceof CronTrigger) {
            outCtx.writeShort(70);
            CronTrigger cronTrigger = (CronTrigger)trigger;
            outCtx.writeLong(cronTrigger.getStartTime().getTime());
            if (cronTrigger.getEndTime() != null) {
                outCtx.writeBoolean(true);
                outCtx.writeLong(cronTrigger.getEndTime().getTime());
            } else {
                outCtx.writeBoolean(false);
            }
            outCtx.writeInt(cronTrigger.getRepeatLimit());
            outCtx.writeInt(cronTrigger.getRepeatCount());
            outCtx.writeUTF(cronTrigger.getCronEx().getCronExpression());
            if (cronTrigger.getNextFireTime() != null) {
                outCtx.writeBoolean(true);
                outCtx.writeLong(cronTrigger.getNextFireTime().getTime());
            } else {
                outCtx.writeBoolean(false);
            }
            outCtx.writeObject(cronTrigger.getCalendarNames());
        } else if (trigger instanceof IntervalTrigger) {
            outCtx.writeShort(71);
            IntervalTrigger intTrigger = (IntervalTrigger)trigger;
            outCtx.writeLong(intTrigger.getStartTime().getTime());
            if (intTrigger.getEndTime() != null) {
                outCtx.writeBoolean(true);
                outCtx.writeLong(intTrigger.getEndTime().getTime());
            } else {
                outCtx.writeBoolean(false);
            }
            outCtx.writeInt(intTrigger.getRepeatLimit());
            outCtx.writeInt(intTrigger.getRepeatCount());
            if (intTrigger.getNextFireTime() != null) {
                outCtx.writeBoolean(true);
                outCtx.writeLong(intTrigger.getNextFireTime().getTime());
            } else {
                outCtx.writeBoolean(false);
            }
            outCtx.writeLong(intTrigger.getPeriod());
            outCtx.writeObject(intTrigger.getCalendarNames());
        } else if (trigger instanceof PointInTimeTrigger) {
            outCtx.writeShort(72);
            PointInTimeTrigger pinTrigger = (PointInTimeTrigger)trigger;
            outCtx.writeLong(pinTrigger.hasNextFireTime().getTime());
        }
    }

    public static class TupleSorter
    implements Comparator<Map.Entry<LeftTuple, Integer>> {
        public static final TupleSorter instance = new TupleSorter();

        @Override
        public int compare(Map.Entry<LeftTuple, Integer> e1, Map.Entry<LeftTuple, Integer> e2) {
            return e1.getValue() - e2.getValue();
        }
    }

    public static class HandleSorter
    implements Comparator<InternalFactHandle> {
        @Override
        public int compare(InternalFactHandle h1, InternalFactHandle h2) {
            return h1.getId() - h2.getId();
        }
    }

    public static class EqualityKeySorter
    implements Comparator<EqualityKey> {
        public static final EqualityKeySorter instance = new EqualityKeySorter();

        @Override
        public int compare(EqualityKey key1, EqualityKey key2) {
            return key1.getFactHandle().getId() - key2.getFactHandle().getId();
        }
    }

    public static class RuleFlowGroupSorter
    implements Comparator<RuleFlowGroup> {
        public static final RuleFlowGroupSorter instance = new RuleFlowGroupSorter();

        @Override
        public int compare(RuleFlowGroup group1, RuleFlowGroup group2) {
            return group1.getName().compareTo(group2.getName());
        }
    }

    public static class AgendaGroupSorter
    implements Comparator<AgendaGroup> {
        public static final AgendaGroupSorter instance = new AgendaGroupSorter();

        @Override
        public int compare(AgendaGroup group1, AgendaGroup group2) {
            return group1.getName().compareTo(group2.getName());
        }
    }
}

