/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.base.DroolsQuery;
import org.drools.core.common.BetaConstraints;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.Memory;
import org.drools.core.common.PropagationContextImpl;
import org.drools.core.marshalling.impl.PersisterHelper;
import org.drools.core.marshalling.impl.ProtobufMessages;
import org.drools.core.reteoo.BaseLeftTuple;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.FromNodeLeftTuple;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleMemory;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ReteooWorkingMemory;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RightTupleMemory;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.rule.Accumulate;
import org.drools.core.rule.ContextEntry;
import org.drools.core.rule.Rule;
import org.drools.core.spi.AlphaNodeFieldConstraint;
import org.drools.core.spi.PropagationContext;
import org.drools.core.util.AbstractBaseLinkedListNode;
import org.drools.core.util.ArrayUtils;
import org.drools.core.util.FastIterator;
import org.drools.core.util.Iterator;

public class AccumulateNode
extends BetaNode {
    private static final long serialVersionUID = 510L;
    private boolean unwrapRightObject;
    private Accumulate accumulate;
    private AlphaNodeFieldConstraint[] resultConstraints;
    private BetaConstraints resultBinder;

    public AccumulateNode() {
    }

    public AccumulateNode(int id, LeftTupleSource leftInput, ObjectSource rightInput, AlphaNodeFieldConstraint[] resultConstraints, BetaConstraints sourceBinder, BetaConstraints resultBinder, Accumulate accumulate, boolean unwrapRightObject, BuildContext context) {
        super(id, context.getPartitionId(), context.getRuleBase().getConfiguration().isMultithreadEvaluation(), leftInput, rightInput, sourceBinder, context);
        this.resultBinder = resultBinder;
        this.resultConstraints = resultConstraints;
        this.accumulate = accumulate;
        this.unwrapRightObject = unwrapRightObject;
        this.tupleMemoryEnabled = context.isTupleMemoryEnabled();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.unwrapRightObject = in.readBoolean();
        this.accumulate = (Accumulate)in.readObject();
        this.resultConstraints = (AlphaNodeFieldConstraint[])in.readObject();
        this.resultBinder = (BetaConstraints)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeBoolean(this.unwrapRightObject);
        out.writeObject(this.accumulate);
        out.writeObject(this.resultConstraints);
        out.writeObject(this.resultBinder);
    }

    public Accumulate getAccumulate() {
        return this.accumulate;
    }

    public AlphaNodeFieldConstraint[] getResultConstraints() {
        return this.resultConstraints;
    }

    public BetaConstraints getResultBinder() {
        return this.resultBinder;
    }

    public boolean isUnwrapRightObject() {
        return this.unwrapRightObject;
    }

    @Override
    public void assertLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        Object object;
        AccumulateMemory memory = (AccumulateMemory)workingMemory.getNodeMemory(this);
        AccumulateContext accresult = new AccumulateContext();
        boolean useLeftMemory = true;
        if (!(this.tupleMemoryEnabled || (object = leftTuple.get(0).getObject()) instanceof DroolsQuery && ((DroolsQuery)object).isOpen())) {
            useLeftMemory = false;
        }
        if (useLeftMemory) {
            memory.betaMemory.getLeftTupleMemory().add(leftTuple);
            leftTuple.setObject(accresult);
        }
        accresult.context = this.accumulate.createContext();
        this.accumulate.init(memory.workingMemoryContext, accresult.context, leftTuple, workingMemory);
        this.constraints.updateFromTuple(memory.betaMemory.getContext(), workingMemory, leftTuple);
        RightTupleMemory rightMemory = memory.betaMemory.getRightTupleMemory();
        FastIterator rightIt = this.getRightIterator(rightMemory);
        RightTuple rightTuple = this.getFirstRightTuple(leftTuple, rightMemory, (InternalFactHandle)context.getFactHandle(), rightIt);
        while (rightTuple != null) {
            InternalFactHandle handle = rightTuple.getFactHandle();
            if (this.constraints.isAllowedCachedLeft(memory.betaMemory.getContext(), handle)) {
                this.addMatch(leftTuple, rightTuple, null, null, workingMemory, memory, accresult, useLeftMemory);
            }
            rightTuple = (RightTuple)rightIt.next(rightTuple);
        }
        this.constraints.resetTuple(memory.betaMemory.getContext());
        if (accresult.getAction() == null) {
            this.evaluateResultConstraints(ActivitySource.LEFT, leftTuple, context, workingMemory, memory, accresult, useLeftMemory);
        }
    }

    @Override
    public void retractLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        AccumulateMemory memory = (AccumulateMemory)workingMemory.getNodeMemory(this);
        memory.getBetaMemory().getLeftTupleMemory().remove(leftTuple);
        AccumulateContext accctx = (AccumulateContext)leftTuple.getObject();
        if (accctx.getAction() != null) {
            context.removeInsertAction(accctx.getAction());
        }
        leftTuple.setObject(null);
        this.removePreviousMatchesForLeftTuple(leftTuple, workingMemory, memory, accctx);
        if (accctx.propagated) {
            this.sink.propagateRetractLeftTupleDestroyRightTuple(leftTuple, context, workingMemory);
        }
    }

    @Override
    public void assertRightTuple(RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        AccumulateMemory memory = (AccumulateMemory)workingMemory.getNodeMemory(this);
        memory.betaMemory.getRightTupleMemory().add(rightTuple);
        if (memory.betaMemory.getLeftTupleMemory() == null || memory.betaMemory.getLeftTupleMemory().size() == 0) {
            return;
        }
        this.constraints.updateFromFactHandle(memory.betaMemory.getContext(), workingMemory, rightTuple.getFactHandle());
        LeftTupleMemory leftMemory = memory.betaMemory.getLeftTupleMemory();
        FastIterator leftIt = this.getLeftIterator(leftMemory);
        LeftTuple leftTuple = this.getFirstLeftTuple(rightTuple, leftMemory, context, leftIt);
        while (leftTuple != null) {
            if (this.constraints.isAllowedCachedRight(memory.betaMemory.getContext(), leftTuple)) {
                AccumulateContext accctx = (AccumulateContext)leftTuple.getObject();
                this.addMatch(leftTuple, rightTuple, null, null, workingMemory, memory, accctx, true);
                if (accctx.getAction() == null) {
                    ReteooWorkingMemory.EvaluateResultConstraints action = new ReteooWorkingMemory.EvaluateResultConstraints(ActivitySource.LEFT, leftTuple, context, workingMemory, memory, accctx, true, this);
                    accctx.setAction(action);
                    context.addInsertAction(action);
                }
            }
            leftTuple = (LeftTuple)leftIt.next(leftTuple);
        }
        this.constraints.resetFactHandle(memory.betaMemory.getContext());
    }

    @Override
    public void retractRightTuple(RightTuple rightTuple, PropagationContext pctx, InternalWorkingMemory workingMemory) {
        AccumulateMemory memory = (AccumulateMemory)workingMemory.getNodeMemory(this);
        BetaMemory bm = memory.getBetaMemory();
        if (this.isUnlinkingEnabled()) {
            rightTuple.setPropagationContext(pctx);
            AccumulateNode.doDeleteRightTuple(rightTuple, this, workingMemory, bm);
            return;
        }
        InternalFactHandle origin = (InternalFactHandle)pctx.getFactHandleOrigin();
        if (pctx.getType() == 5) {
            ((PropagationContextImpl)pctx).setFactHandle(null);
        }
        bm.getRightTupleMemory().remove(rightTuple);
        this.removePreviousMatchesForRightTuple(rightTuple, pctx, workingMemory, memory, rightTuple.firstChild);
        if (pctx.getType() == 5) {
            ((PropagationContextImpl)pctx).setFactHandle(origin);
        }
        rightTuple.unlinkFromRightParent();
    }

    @Override
    public void modifyLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        AccumulateMemory memory = (AccumulateMemory)workingMemory.getNodeMemory(this);
        AccumulateContext accctx = (AccumulateContext)leftTuple.getObject();
        BetaMemory bm = memory.betaMemory;
        bm.getLeftTupleMemory().removeAdd(leftTuple);
        this.constraints.updateFromTuple(bm.getContext(), workingMemory, leftTuple);
        LeftTuple childLeftTuple = this.getFirstMatch(leftTuple, accctx, false);
        RightTupleMemory rightMemory = bm.getRightTupleMemory();
        FastIterator rightIt = this.getRightIterator(rightMemory);
        RightTuple rightTuple = this.getFirstRightTuple(leftTuple, rightMemory, (InternalFactHandle)context.getFactHandle(), rightIt);
        if (childLeftTuple != null && rightMemory.isIndexed() && !rightIt.isFullIterator() && (rightTuple == null || rightTuple.getMemory() != childLeftTuple.getRightParent().getMemory())) {
            this.removePreviousMatchesForLeftTuple(leftTuple, workingMemory, memory, accctx);
            childLeftTuple = null;
        }
        if (rightTuple != null) {
            if (childLeftTuple == null) {
                while (rightTuple != null) {
                    InternalFactHandle handle = rightTuple.getFactHandle();
                    if (this.constraints.isAllowedCachedLeft(bm.getContext(), handle)) {
                        this.addMatch(leftTuple, rightTuple, null, null, workingMemory, memory, accctx, true);
                    }
                    rightTuple = (RightTuple)rightIt.next(rightTuple);
                }
            } else {
                boolean isDirty = false;
                while (rightTuple != null) {
                    LeftTuple temp;
                    InternalFactHandle handle = rightTuple.getFactHandle();
                    if (this.constraints.isAllowedCachedLeft(bm.getContext(), handle)) {
                        if (childLeftTuple == null || childLeftTuple.getRightParent() != rightTuple) {
                            this.addMatch(leftTuple, rightTuple, childLeftTuple, null, workingMemory, memory, accctx, true);
                        } else {
                            temp = childLeftTuple.getLeftParentNext();
                            childLeftTuple.reAddRight();
                            childLeftTuple = temp;
                        }
                    } else if (childLeftTuple != null && childLeftTuple.getRightParent() == rightTuple) {
                        temp = childLeftTuple.getLeftParentNext();
                        this.removeMatch(rightTuple, childLeftTuple, workingMemory, memory, accctx, false);
                        childLeftTuple = temp;
                        isDirty = !this.accumulate.supportsReverse();
                    }
                    rightTuple = (RightTuple)rightIt.next(rightTuple);
                }
                if (isDirty) {
                    this.reaccumulateForLeftTuple(leftTuple, workingMemory, memory, accctx);
                }
            }
        }
        this.constraints.resetTuple(memory.betaMemory.getContext());
        if (accctx.getAction() == null) {
            this.evaluateResultConstraints(ActivitySource.LEFT, leftTuple, context, workingMemory, memory, accctx, true);
        }
    }

    @Override
    public void modifyRightTuple(RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        AccumulateMemory memory = (AccumulateMemory)workingMemory.getNodeMemory(this);
        BetaMemory bm = memory.betaMemory;
        bm.getRightTupleMemory().removeAdd(rightTuple);
        if (bm.getLeftTupleMemory() == null || bm.getLeftTupleMemory().size() == 0) {
            return;
        }
        LeftTuple childLeftTuple = rightTuple.firstChild;
        LeftTupleMemory leftMemory = bm.getLeftTupleMemory();
        FastIterator leftIt = this.getLeftIterator(leftMemory);
        LeftTuple leftTuple = this.getFirstLeftTuple(rightTuple, leftMemory, context, leftIt);
        this.constraints.updateFromFactHandle(bm.getContext(), workingMemory, rightTuple.getFactHandle());
        if (childLeftTuple != null && leftMemory.isIndexed() && !leftIt.isFullIterator() && (leftTuple == null || leftTuple.getMemory() != childLeftTuple.getLeftParent().getMemory())) {
            this.removePreviousMatchesForRightTuple(rightTuple, context, workingMemory, memory, childLeftTuple);
            childLeftTuple = null;
        }
        if (leftTuple != null) {
            if (childLeftTuple == null) {
                while (leftTuple != null) {
                    if (this.constraints.isAllowedCachedRight(bm.getContext(), leftTuple)) {
                        AccumulateContext accctx = (AccumulateContext)leftTuple.getObject();
                        this.addMatch(leftTuple, rightTuple, null, null, workingMemory, memory, accctx, true);
                        if (accctx.getAction() == null) {
                            ReteooWorkingMemory.EvaluateResultConstraints action = new ReteooWorkingMemory.EvaluateResultConstraints(ActivitySource.LEFT, leftTuple, context, workingMemory, memory, accctx, true, this);
                            accctx.setAction(action);
                            context.addInsertAction(action);
                        }
                    }
                    leftTuple = (LeftTuple)leftIt.next(leftTuple);
                }
            } else {
                while (leftTuple != null) {
                    ReteooWorkingMemory.EvaluateResultConstraints action;
                    if (this.constraints.isAllowedCachedRight(bm.getContext(), leftTuple)) {
                        AccumulateContext accctx = (AccumulateContext)leftTuple.getObject();
                        LeftTuple temp = null;
                        if (childLeftTuple != null && childLeftTuple.getLeftParent() == leftTuple) {
                            temp = childLeftTuple.getRightParentNext();
                            childLeftTuple.reAddLeft();
                            this.removeMatch(rightTuple, childLeftTuple, workingMemory, memory, accctx, true);
                            childLeftTuple = temp;
                        }
                        this.addMatch(leftTuple, rightTuple, null, childLeftTuple, workingMemory, memory, accctx, true);
                        if (temp != null) {
                            childLeftTuple = temp;
                        }
                        if (accctx.getAction() == null) {
                            action = new ReteooWorkingMemory.EvaluateResultConstraints(ActivitySource.LEFT, leftTuple, context, workingMemory, memory, accctx, true, this);
                            accctx.setAction(action);
                            context.addInsertAction(action);
                        }
                    } else if (childLeftTuple != null && childLeftTuple.getLeftParent() == leftTuple) {
                        LeftTuple temp = childLeftTuple.getRightParentNext();
                        AccumulateContext accctx = (AccumulateContext)leftTuple.getObject();
                        this.removeMatch(rightTuple, childLeftTuple, workingMemory, memory, accctx, true);
                        if (accctx.getAction() == null) {
                            action = new ReteooWorkingMemory.EvaluateResultConstraints(ActivitySource.LEFT, leftTuple, context, workingMemory, memory, accctx, true, this);
                            accctx.setAction(action);
                            context.addInsertAction(action);
                        }
                        childLeftTuple = temp;
                    }
                    leftTuple = (LeftTuple)leftIt.next(leftTuple);
                }
            }
        }
        this.constraints.resetFactHandle(bm.getContext());
    }

    public void evaluateResultConstraints(ActivitySource source, LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory, AccumulateMemory memory, AccumulateContext accctx, boolean useLeftMemory) {
        Object[] result;
        Object[] resultArray = this.accumulate.getResult(memory.workingMemoryContext, accctx.context, leftTuple, workingMemory);
        Object object = result = this.accumulate.isMultiFunction() ? resultArray : resultArray[0];
        if (result == null) {
            return;
        }
        if (accctx.result == null) {
            InternalFactHandle handle = this.createResultFactHandle(context, workingMemory, leftTuple, result);
            accctx.setResultFactHandle(handle);
            accctx.result = this.createRightTuple(handle, this, context);
        } else {
            accctx.result.getFactHandle().setObject(result);
        }
        boolean isAllowed = result != null;
        int length = this.resultConstraints.length;
        for (int i = 0; isAllowed && i < length; ++i) {
            if (this.resultConstraints[i].isAllowed(accctx.result.getFactHandle(), workingMemory, memory.alphaContexts[i])) continue;
            isAllowed = false;
        }
        if (isAllowed) {
            this.resultBinder.updateFromTuple(memory.resultsContext, workingMemory, leftTuple);
            if (!this.resultBinder.isAllowedCachedLeft(memory.resultsContext, accctx.result.getFactHandle())) {
                isAllowed = false;
            }
            this.resultBinder.resetTuple(memory.resultsContext);
        }
        if (accctx.propagated) {
            LeftTuple[] matchings = this.splitList(leftTuple, accctx, false);
            if (isAllowed) {
                if (ActivitySource.LEFT.equals((Object)source)) {
                    this.sink.propagateModifyChildLeftTuple(leftTuple.getFirstChild(), leftTuple, context, workingMemory, useLeftMemory);
                } else {
                    this.sink.propagateModifyChildLeftTuple(leftTuple.getFirstChild(), accctx.result, context, workingMemory, useLeftMemory);
                }
            } else {
                PropagationContextImpl cancelContext = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 1, (Rule)context.getRule(), context.getLeftTupleOrigin(), (InternalFactHandle)context.getFactHandle());
                this.sink.propagateRetractLeftTuple(leftTuple, cancelContext, workingMemory);
                accctx.propagated = false;
            }
            this.restoreList(leftTuple, matchings);
        } else if (isAllowed) {
            LeftTuple[] matchings = this.splitList(leftTuple, accctx, false);
            this.sink.propagateAssertLeftTuple(leftTuple, accctx.result, null, null, context, workingMemory, useLeftMemory);
            accctx.propagated = true;
            this.restoreList(leftTuple, matchings);
        }
    }

    public InternalFactHandle createResultFactHandle(PropagationContext context, InternalWorkingMemory workingMemory, LeftTuple leftTuple, Object result) {
        Map map;
        InternalFactHandle handle = null;
        ProtobufMessages.FactHandle _handle = null;
        if (context.getReaderContext() != null && (map = (Map)context.getReaderContext().nodeMemories.get(this.getId())) != null) {
            _handle = (ProtobufMessages.FactHandle)map.get(PersisterHelper.createTupleKey(leftTuple));
        }
        handle = _handle != null ? workingMemory.getFactHandleFactory().newFactHandle(_handle.getId(), result, _handle.getRecency(), workingMemory.getObjectTypeConfigurationRegistry().getObjectTypeConf(context.getEntryPoint(), result), workingMemory, null) : workingMemory.getFactHandleFactory().newFactHandle(result, workingMemory.getObjectTypeConfigurationRegistry().getObjectTypeConf(context.getEntryPoint(), result), workingMemory, null);
        return handle;
    }

    @Override
    public void updateSink(LeftTupleSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        AccumulateMemory memory = (AccumulateMemory)workingMemory.getNodeMemory(this);
        Iterator tupleIter = memory.betaMemory.getLeftTupleMemory().iterator();
        LeftTuple leftTuple = (LeftTuple)tupleIter.next();
        while (leftTuple != null) {
            AccumulateContext accctx = (AccumulateContext)leftTuple.getObject();
            if (accctx.propagated) {
                LeftTuple[] matchings = this.splitList(leftTuple, accctx, true);
                sink.assertLeftTuple(sink.createLeftTuple(leftTuple, accctx.result, null, null, sink, true), context, workingMemory);
                this.restoreList(leftTuple, matchings);
            }
            leftTuple = (LeftTuple)tupleIter.next();
        }
    }

    protected void doRemove(InternalWorkingMemory workingMemory, AccumulateMemory memory) {
    }

    @Override
    public int hashCode() {
        return this.leftInput.hashCode() ^ this.rightInput.hashCode() ^ this.accumulate.hashCode() ^ this.resultBinder.hashCode() ^ ArrayUtils.hashCode(this.resultConstraints);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof AccumulateNode)) {
            return false;
        }
        AccumulateNode other = (AccumulateNode)object;
        if (!(this.getClass() == other.getClass() && this.leftInput.equals(other.leftInput) && this.rightInput.equals(other.rightInput) && this.constraints.equals(other.constraints))) {
            return false;
        }
        return this.accumulate.equals(other.accumulate) && this.resultBinder.equals(other.resultBinder) && Arrays.equals(this.resultConstraints, other.resultConstraints);
    }

    @Override
    public Memory createMemory(RuleBaseConfiguration config, InternalWorkingMemory wm) {
        AccumulateMemory memory = new AccumulateMemory();
        memory.betaMemory = this.constraints.createBetaMemory(config, (short)211);
        memory.workingMemoryContext = this.accumulate.createWorkingMemoryContext();
        memory.resultsContext = this.resultBinder.createContext();
        memory.alphaContexts = new ContextEntry[this.resultConstraints.length];
        for (int i = 0; i < this.resultConstraints.length; ++i) {
            memory.alphaContexts[i] = this.resultConstraints[i].createContextEntry();
        }
        return memory;
    }

    @Override
    public LeftTuple createPeer(LeftTuple original) {
        FromNodeLeftTuple peer = new FromNodeLeftTuple();
        peer.initPeer((BaseLeftTuple)original, this);
        original.setPeer(peer);
        return peer;
    }

    @Override
    public short getType() {
        return 211;
    }

    private void addMatch(LeftTuple leftTuple, RightTuple rightTuple, LeftTuple currentLeftChild, LeftTuple currentRightChild, InternalWorkingMemory workingMemory, AccumulateMemory memory, AccumulateContext accresult, boolean useLeftMemory) {
        LeftTuple tuple = leftTuple;
        InternalFactHandle handle = rightTuple.getFactHandle();
        if (this.unwrapRightObject) {
            tuple = (LeftTuple)handle.getObject();
        }
        this.accumulate.accumulate(memory.workingMemoryContext, accresult.context, tuple, handle, workingMemory);
        if (useLeftMemory) {
            this.createLeftTuple(leftTuple, rightTuple, currentLeftChild, currentRightChild, this, true);
        }
    }

    private void removeMatch(RightTuple rightTuple, LeftTuple match, InternalWorkingMemory workingMemory, AccumulateMemory memory, AccumulateContext accctx, boolean reaccumulate) {
        LeftTuple leftTuple = match.getLeftParent();
        if (match != null) {
            match.unlinkFromLeftParent();
            match.unlinkFromRightParent();
        }
        InternalFactHandle handle = rightTuple.getFactHandle();
        LeftTuple tuple = leftTuple;
        if (this.unwrapRightObject) {
            tuple = (LeftTuple)handle.getObject();
        }
        if (this.accumulate.supportsReverse()) {
            this.accumulate.reverse(memory.workingMemoryContext, accctx.context, tuple, handle, workingMemory);
        } else if (reaccumulate) {
            this.reaccumulateForLeftTuple(leftTuple, workingMemory, memory, accctx);
        }
    }

    private void reaccumulateForLeftTuple(LeftTuple leftTuple, InternalWorkingMemory workingMemory, AccumulateMemory memory, AccumulateContext accctx) {
        this.accumulate.init(memory.workingMemoryContext, accctx.context, leftTuple, workingMemory);
        for (LeftTuple childMatch = this.getFirstMatch(leftTuple, accctx, false); childMatch != null; childMatch = childMatch.getLeftParentNext()) {
            InternalFactHandle childHandle = childMatch.getRightParent().getFactHandle();
            LeftTuple tuple = leftTuple;
            if (this.unwrapRightObject) {
                tuple = (LeftTuple)childHandle.getObject();
                childHandle = tuple.getLastHandle();
            }
            this.accumulate.accumulate(memory.workingMemoryContext, accctx.context, tuple, childHandle, workingMemory);
        }
    }

    private void removePreviousMatchesForLeftTuple(LeftTuple leftTuple, InternalWorkingMemory workingMemory, AccumulateMemory memory, AccumulateContext accctx) {
        LeftTuple[] matchings = this.splitList(leftTuple, accctx, false);
        for (LeftTuple match = matchings[0]; match != null; match = match.getLeftParentNext()) {
            match.unlinkFromRightParent();
        }
        this.accumulate.init(memory.workingMemoryContext, accctx.context, leftTuple, workingMemory);
    }

    private void removePreviousMatchesForRightTuple(RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory, AccumulateMemory memory, LeftTuple firstChild) {
        LeftTuple match = firstChild;
        while (match != null) {
            LeftTuple tmp = match.getRightParentNext();
            LeftTuple parent = match.getLeftParent();
            AccumulateContext accctx = (AccumulateContext)parent.getObject();
            this.removeMatch(rightTuple, match, workingMemory, memory, accctx, true);
            if (accctx.getAction() == null) {
                ReteooWorkingMemory.EvaluateResultConstraints action = new ReteooWorkingMemory.EvaluateResultConstraints(ActivitySource.LEFT, parent, context, workingMemory, memory, accctx, true, this);
                accctx.setAction(action);
                context.addInsertAction(action);
            }
            match = tmp;
        }
    }

    protected LeftTuple[] splitList(LeftTuple parent, AccumulateContext accctx, boolean isUpdatingSink) {
        LeftTuple[] matchings = new LeftTuple[2];
        matchings[0] = this.getFirstMatch(parent, accctx, isUpdatingSink);
        LeftTuple leftTuple = matchings[1] = matchings[0] != null ? parent.getLastChild() : null;
        if (matchings[0] != null) {
            if (parent.getFirstChild() == matchings[0]) {
                parent.setFirstChild(null);
            }
            parent.setLastChild(matchings[0].getLeftParentPrevious());
            if (parent.getLastChild() != null) {
                parent.getLastChild().setLeftParentNext(null);
                matchings[0].setLeftParentPrevious(null);
            }
        }
        return matchings;
    }

    private void restoreList(LeftTuple parent, LeftTuple[] matchings) {
        if (parent.getFirstChild() == null) {
            parent.setFirstChild(matchings[0]);
            parent.setLastChild(matchings[1]);
        } else if (matchings[0] != null) {
            parent.getLastChild().setLeftParentNext(matchings[0]);
            matchings[0].setLeftParentPrevious(parent.getLastChild());
            parent.setLastChild(matchings[1]);
        }
    }

    public LeftTuple getFirstMatch(LeftTuple leftTuple, AccumulateContext accctx, boolean isUpdatingSink) {
        LeftTuple child = leftTuple.getFirstChild();
        if (accctx.propagated) {
            int target = isUpdatingSink ? this.sink.size() - 1 : this.sink.size();
            for (int i = 0; i < target; ++i) {
                child = child.getLeftParentNext();
            }
        }
        return child;
    }

    @Override
    public LeftTuple createLeftTuple(InternalFactHandle factHandle, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        return new FromNodeLeftTuple(factHandle, sink, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createLeftTuple(InternalFactHandle factHandle, LeftTuple leftTuple, LeftTupleSink sink) {
        return new FromNodeLeftTuple(factHandle, leftTuple, sink);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, LeftTupleSink sink, PropagationContext pctx, boolean leftTupleMemoryEnabled) {
        return new FromNodeLeftTuple(leftTuple, sink, pctx, leftTupleMemoryEnabled);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTupleSink sink) {
        return new FromNodeLeftTuple(leftTuple, rightTuple, sink);
    }

    @Override
    public LeftTuple createLeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTuple currentLeftChild, LeftTuple currentRightChild, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        return new FromNodeLeftTuple(leftTuple, rightTuple, currentLeftChild, currentRightChild, sink, leftTupleMemoryEnabled);
    }

    public static enum ActivitySource {
        LEFT,
        RIGHT;

    }

    public static class AccumulateContext
    implements Externalizable {
        public Serializable[] context;
        public RightTuple result;
        public InternalFactHandle resultFactHandle;
        public LeftTuple resultLeftTuple;
        public boolean propagated;
        private ReteooWorkingMemory.EvaluateResultConstraints action;

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.context = (Serializable[])in.readObject();
            this.result = (RightTuple)in.readObject();
            this.propagated = in.readBoolean();
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.context);
            out.writeObject(this.result);
            out.writeBoolean(this.propagated);
        }

        public ReteooWorkingMemory.EvaluateResultConstraints getAction() {
            return this.action;
        }

        public void setAction(ReteooWorkingMemory.EvaluateResultConstraints action) {
            this.action = action;
        }

        public InternalFactHandle getResultFactHandle() {
            return this.resultFactHandle;
        }

        public void setResultFactHandle(InternalFactHandle resultFactHandle) {
            this.resultFactHandle = resultFactHandle;
        }

        public LeftTuple getResultLeftTuple() {
            return this.resultLeftTuple;
        }

        public void setResultLeftTuple(LeftTuple resultLeftTuple) {
            this.resultLeftTuple = resultLeftTuple;
        }
    }

    public static class AccumulateMemory
    extends AbstractBaseLinkedListNode<Memory>
    implements Memory {
        public Object[] workingMemoryContext;
        public BetaMemory betaMemory;
        public ContextEntry[] resultsContext;
        public ContextEntry[] alphaContexts;

        public BetaMemory getBetaMemory() {
            return this.betaMemory;
        }

        @Override
        public short getNodeType() {
            return 211;
        }

        @Override
        public SegmentMemory getSegmentMemory() {
            return this.betaMemory.getSegmentMemory();
        }

        @Override
        public void setSegmentMemory(SegmentMemory segmentMemory) {
            this.betaMemory.setSegmentMemory(segmentMemory);
        }
    }
}

