/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import org.drools.core.RuleBaseConfiguration;
import org.drools.core.base.ClassObjectType;
import org.drools.core.base.DroolsQuery;
import org.drools.core.base.ValueType;
import org.drools.core.common.AbstractRuleBase;
import org.drools.core.common.DroolsObjectInputStream;
import org.drools.core.common.EventFactHandle;
import org.drools.core.common.InternalFactHandle;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.common.Memory;
import org.drools.core.common.MemoryFactory;
import org.drools.core.common.PropagationContextImpl;
import org.drools.core.common.UpdateContext;
import org.drools.core.marshalling.impl.MarshallerReaderContext;
import org.drools.core.marshalling.impl.MarshallerWriteContext;
import org.drools.core.marshalling.impl.ProtobufMessages;
import org.drools.core.marshalling.impl.TimersInputMarshaller;
import org.drools.core.marshalling.impl.TimersOutputMarshaller;
import org.drools.core.reteoo.AlphaNode;
import org.drools.core.reteoo.BetaNode;
import org.drools.core.reteoo.EntryPointNode;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.LeftTuple;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.ModifyPreviousTuples;
import org.drools.core.reteoo.NodeSet;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ReteooBuilder;
import org.drools.core.reteoo.ReteooRuleBase;
import org.drools.core.reteoo.ReteooWorkingMemory;
import org.drools.core.reteoo.RightTuple;
import org.drools.core.reteoo.RuleRemovalContext;
import org.drools.core.reteoo.SegmentMemory;
import org.drools.core.reteoo.WindowNode;
import org.drools.core.reteoo.builder.BuildContext;
import org.drools.core.reteoo.compiled.CompiledNetwork;
import org.drools.core.rule.Declaration;
import org.drools.core.rule.EntryPoint;
import org.drools.core.rule.EvalCondition;
import org.drools.core.spi.Constraint;
import org.drools.core.spi.ObjectType;
import org.drools.core.spi.PropagationContext;
import org.drools.core.time.Job;
import org.drools.core.time.JobContext;
import org.drools.core.time.JobHandle;
import org.drools.core.time.TimerService;
import org.drools.core.time.impl.DefaultJobHandle;
import org.drools.core.time.impl.PointInTimeTrigger;
import org.drools.core.util.Iterator;
import org.drools.core.util.ObjectHashSet;

public class ObjectTypeNode
extends ObjectSource
implements ObjectSink,
Externalizable,
MemoryFactory {
    private static final long serialVersionUID = 510L;
    protected ObjectType objectType;
    private boolean objectMemoryEnabled;
    private long expirationOffset = -1L;
    public static final transient ExpireJob job = new ExpireJob();
    private boolean queryNode;
    protected CompiledNetwork compiledNetwork;
    protected transient boolean dirty;
    protected transient IdGenerator idGenerator;
    public static Id DEFAULT_ID = new Id(Object.class, 0);

    public int getOtnIdCounter() {
        return this.idGenerator.otnIdCounter;
    }

    public ObjectTypeNode() {
    }

    public ObjectTypeNode(int id, EntryPointNode source, ObjectType objectType, BuildContext context) {
        super(id, context.getPartitionId(), context.getRuleBase().getConfiguration().isMultithreadEvaluation(), source, context.getRuleBase().getConfiguration().getAlphaNodeHashingThreshold());
        this.objectType = objectType;
        this.idGenerator = new IdGenerator(objectType);
        this.setObjectMemoryEnabled(context.isObjectTypeNodeMemoryEnabled());
        if (ClassObjectType.DroolsQuery_ObjectType.isAssignableFrom(objectType)) {
            this.queryNode = true;
        }
        this.dirty = true;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.objectType = (ObjectType)in.readObject();
        if (this.objectType instanceof ClassObjectType) {
            this.objectType = ((AbstractRuleBase)((DroolsObjectInputStream)in).getRuleBase()).getClassFieldAccessorCache().getClassObjectType((ClassObjectType)this.objectType);
        }
        this.idGenerator = new IdGenerator(this.objectType);
        this.objectMemoryEnabled = in.readBoolean();
        this.expirationOffset = in.readLong();
        this.queryNode = in.readBoolean();
        this.dirty = true;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.objectType);
        out.writeBoolean(this.objectMemoryEnabled);
        out.writeLong(this.expirationOffset);
        out.writeBoolean(this.queryNode);
    }

    @Override
    public short getType() {
        return 30;
    }

    public ObjectType getObjectType() {
        return this.objectType;
    }

    @Override
    public long calculateDeclaredMask(List<String> settableProperties) {
        return 0L;
    }

    public boolean isAssignableFrom(ObjectType objectType) {
        return this.objectType.isAssignableFrom(objectType);
    }

    public void setCompiledNetwork(CompiledNetwork compiledNetwork) {
        this.compiledNetwork = compiledNetwork;
        this.compiledNetwork.setObjectTypeNode(this);
    }

    @Override
    public void assertObject(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory) {
        if (this.dirty) {
            this.resetIdGenerator();
            ObjectTypeNode.updateTupleSinkId(this, this);
            this.dirty = false;
        }
        if (this.objectMemoryEnabled && (!this.queryNode || ((DroolsQuery)factHandle.getObject()).isOpen())) {
            ObjectTypeNodeMemory memory = (ObjectTypeNodeMemory)workingMemory.getNodeMemory(this);
            memory.memory.add(factHandle, false);
        }
        if (this.compiledNetwork != null) {
            this.compiledNetwork.assertObject(factHandle, context, workingMemory);
        } else {
            this.sink.propagateAssertObject(factHandle, context, workingMemory);
        }
        if (context.getReaderContext() == null && this.objectType.isEvent() && this.expirationOffset >= 0L && this.expirationOffset != Long.MAX_VALUE) {
            ReteooWorkingMemory.WorkingMemoryReteExpireAction expire = new ReteooWorkingMemory.WorkingMemoryReteExpireAction(factHandle, this);
            TimerService clock = workingMemory.getTimerService();
            long nextTimestamp = Math.max(clock.getCurrentTime() + this.expirationOffset, ((EventFactHandle)factHandle).getEndTimestamp() + this.expirationOffset);
            ExpireJobContext jobctx = new ExpireJobContext(expire, workingMemory);
            JobHandle handle = clock.scheduleJob(job, jobctx, new PointInTimeTrigger(nextTimestamp, null, null));
            jobctx.setJobHandle(handle);
        }
    }

    public void retractObject(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory) {
        if (this.dirty) {
            this.resetIdGenerator();
            ObjectTypeNode.updateTupleSinkId(this, this);
            this.dirty = false;
        }
        if (this.objectMemoryEnabled && (!this.queryNode || ((DroolsQuery)factHandle.getObject()).isOpen())) {
            ObjectTypeNodeMemory memory = (ObjectTypeNodeMemory)workingMemory.getNodeMemory(this);
            memory.memory.remove(factHandle);
        }
        ObjectTypeNode.doRetractObject(factHandle, context, workingMemory);
    }

    public static void doRetractObject(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory) {
        for (RightTuple rightTuple = factHandle.getFirstRightTuple(); rightTuple != null; rightTuple = rightTuple.getHandleNext()) {
            rightTuple.getRightTupleSink().retractRightTuple(rightTuple, context, workingMemory);
        }
        factHandle.clearRightTuples();
        for (LeftTuple leftTuple = factHandle.getFirstLeftTuple(); leftTuple != null; leftTuple = leftTuple.getLeftParentNext()) {
            ((LeftInputAdapterNode)leftTuple.getLeftTupleSink().getLeftTupleSource()).retractLeftTuple(leftTuple, context, workingMemory);
        }
        factHandle.clearLeftTuples();
    }

    protected void resetIdGenerator() {
        this.idGenerator.reset();
    }

    @Override
    public void modifyObject(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        if (this.dirty) {
            this.resetIdGenerator();
            ObjectTypeNode.updateTupleSinkId(this, this);
            this.dirty = false;
        }
        context.setObjectType(this.objectType);
        if (this.compiledNetwork != null) {
            this.compiledNetwork.modifyObject(factHandle, modifyPreviousTuples, context.adaptModificationMaskForObjectType(this.objectType, workingMemory), workingMemory);
        } else {
            this.sink.propagateModifyObject(factHandle, modifyPreviousTuples, context.adaptModificationMaskForObjectType(this.objectType, workingMemory), workingMemory);
        }
    }

    @Override
    public void updateSink(ObjectSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        if (this.dirty) {
            this.resetIdGenerator();
            ObjectTypeNode.updateTupleSinkId(this, this);
            this.dirty = false;
        }
        ObjectTypeNodeMemory memory = (ObjectTypeNodeMemory)workingMemory.getNodeMemory(this);
        Iterator it = memory.memory.iterator();
        ObjectHashSet.ObjectEntry entry = (ObjectHashSet.ObjectEntry)it.next();
        while (entry != null) {
            sink.assertObject((InternalFactHandle)entry.getValue(), context, workingMemory);
            entry = (ObjectHashSet.ObjectEntry)it.next();
        }
    }

    @Override
    public void attach(BuildContext context) {
        this.source.addObjectSink(this);
        if (context == null || context.getRuleBase().getConfiguration().isPhreakEnabled()) {
            return;
        }
        for (InternalWorkingMemory workingMemory : context.getWorkingMemories()) {
            PropagationContextImpl propagationContext = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 3, null, null, null);
            propagationContext.setEntryPoint(((EntryPointNode)this.source).getEntryPoint());
            this.source.updateSink(this, propagationContext, workingMemory);
        }
    }

    @Override
    public void networkUpdated(UpdateContext updateContext) {
        this.dirty = true;
    }

    protected static void updateTupleSinkId(ObjectTypeNode otn, ObjectSource source) {
        for (ObjectSink sink : source.sink.getSinks()) {
            if (sink instanceof BetaNode) {
                ((BetaNode)sink).setRightInputOtnId(otn.nextOtnId());
                continue;
            }
            if (sink instanceof LeftInputAdapterNode) {
                for (LeftTupleSink liaChildSink : ((LeftInputAdapterNode)sink).getSinkPropagator().getSinks()) {
                    liaChildSink.setLeftInputOtnId(otn.nextOtnId());
                }
                continue;
            }
            if (sink instanceof WindowNode) {
                ((WindowNode)sink).setRightInputOtnId(otn.nextOtnId());
                ObjectTypeNode.updateTupleSinkId(otn, (WindowNode)sink);
                continue;
            }
            if (!(sink instanceof AlphaNode)) continue;
            ObjectTypeNode.updateTupleSinkId(otn, (AlphaNode)sink);
        }
    }

    public Id nextOtnId() {
        return this.idGenerator.nextId();
    }

    @Override
    public void remove(RuleRemovalContext context, ReteooBuilder builder, InternalWorkingMemory[] workingMemories) {
        this.doRemove(context, builder, workingMemories);
    }

    @Override
    protected void doRemove(RuleRemovalContext context, ReteooBuilder builder, InternalWorkingMemory[] workingMemories) {
        if (!context.getRuleBase().getConfiguration().isPhreakEnabled() && context.getCleanupAdapter() != null) {
            for (InternalWorkingMemory workingMemory : workingMemories) {
                RuleRemovalContext.CleanupAdapter adapter = context.getCleanupAdapter();
                ObjectTypeNodeMemory memory = (ObjectTypeNodeMemory)workingMemory.getNodeMemory(this);
                Iterator it = memory.memory.iterator();
                ObjectHashSet.ObjectEntry entry = (ObjectHashSet.ObjectEntry)it.next();
                while (entry != null) {
                    InternalFactHandle handle = (InternalFactHandle)entry.getValue();
                    for (LeftTuple leftTuple = handle.getFirstLeftTuple(); leftTuple != null; leftTuple = leftTuple.getLeftParentNext()) {
                        adapter.cleanUp(leftTuple, workingMemory);
                    }
                    entry = (ObjectHashSet.ObjectEntry)it.next();
                }
            }
            context.setCleanupAdapter(null);
        }
    }

    @Override
    protected void doCollectAncestors(NodeSet nodeSet) {
    }

    @Override
    public Memory createMemory(RuleBaseConfiguration config, InternalWorkingMemory wm) {
        return new ObjectTypeNodeMemory(this);
    }

    public boolean isObjectMemoryEnabled() {
        return this.objectMemoryEnabled;
    }

    public void setObjectMemoryEnabled(boolean objectMemoryEnabled) {
        this.objectMemoryEnabled = objectMemoryEnabled;
    }

    @Override
    public String toString() {
        return "[ObjectTypeNode(" + this.id + ")::" + ((EntryPointNode)this.source).getEntryPoint() + " objectType=" + this.objectType + " expiration=" + this.expirationOffset + "ms ]";
    }

    @Override
    public int hashCode() {
        return this.objectType.hashCode() ^ this.source.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof ObjectTypeNode)) {
            return false;
        }
        ObjectTypeNode other = (ObjectTypeNode)object;
        return this.objectType.equals(other.objectType) && this.source.equals(other.source);
    }

    private boolean usesDeclaration(Constraint[] constraints) {
        boolean usesDecl = false;
        for (int i = 0; !usesDecl && i < constraints.length; ++i) {
            usesDecl = this.usesDeclaration(constraints[i]);
        }
        return usesDecl;
    }

    private boolean usesDeclaration(Constraint constraint) {
        boolean usesDecl = false;
        Declaration[] declarations = constraint.getRequiredDeclarations();
        for (int j = 0; !usesDecl && j < declarations.length; ++j) {
            usesDecl = declarations[j].getPattern().getObjectType() == this.objectType;
        }
        return usesDecl;
    }

    private boolean usesDeclaration(EvalCondition condition) {
        boolean usesDecl = false;
        Declaration[] declarations = condition.getRequiredDeclarations();
        for (int j = 0; !usesDecl && j < declarations.length; ++j) {
            usesDecl = declarations[j].getPattern().getObjectType() == this.objectType;
        }
        return usesDecl;
    }

    public EntryPoint getEntryPoint() {
        return ((EntryPointNode)this.source).getEntryPoint();
    }

    public long getExpirationOffset() {
        return this.expirationOffset;
    }

    public void setExpirationOffset(long expirationOffset) {
        this.expirationOffset = expirationOffset;
        if (!this.objectType.getValueType().equals(ValueType.QUERY_TYPE)) {
            if (this.expirationOffset > 0L) {
                this.setObjectMemoryEnabled(true);
            } else if (this.expirationOffset == 0L) {
                this.setObjectMemoryEnabled(false);
            }
        }
    }

    @Override
    public void byPassModifyToBetaNode(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        throw new UnsupportedOperationException("This should never get called, as the PropertyReactive first happens at the AlphaNode");
    }

    public static class ObjectTypeNodeMemory
    implements Memory {
        public ObjectHashSet memory = new ObjectHashSet();
        private ObjectTypeNode otn;

        ObjectTypeNodeMemory(ObjectTypeNode otn) {
            this.otn = otn;
        }

        @Override
        public short getNodeType() {
            return 30;
        }

        public ObjectHashSet getObjectHashSet() {
            return this.memory;
        }

        @Override
        public SegmentMemory getSegmentMemory() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setSegmentMemory(SegmentMemory segmentMemory) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Memory getPrevious() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setPrevious(Memory previous) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setNext(Memory next) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Memory getNext() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "ObjectTypeMemory " + this.otn;
        }
    }

    public static class ExpireJobContextTimerInputMarshaller
    implements TimersInputMarshaller {
        @Override
        public void read(MarshallerReaderContext inCtx) throws IOException, ClassNotFoundException {
            InternalFactHandle factHandle = inCtx.handles.get(inCtx.readInt());
            String entryPointId = inCtx.readUTF();
            EntryPointNode epn = ((ReteooRuleBase)inCtx.wm.getRuleBase()).getRete().getEntryPointNode(new EntryPoint(entryPointId));
            String className = inCtx.readUTF();
            Class<?> cls = ((ReteooRuleBase)inCtx.wm.getRuleBase()).getRootClassLoader().loadClass(className);
            ObjectTypeNode otn = epn.getObjectTypeNodes().get(new ClassObjectType(cls));
            long nextTimeStamp = inCtx.readLong();
            TimerService clock = inCtx.wm.getTimerService();
            ExpireJobContext jobctx = new ExpireJobContext(new ReteooWorkingMemory.WorkingMemoryReteExpireAction(factHandle, otn), inCtx.wm);
            JobHandle handle = clock.scheduleJob(job, jobctx, new PointInTimeTrigger(nextTimeStamp, null, null));
            jobctx.setJobHandle(handle);
        }

        @Override
        public void deserialize(MarshallerReaderContext inCtx, ProtobufMessages.Timers.Timer _timer) throws ClassNotFoundException {
            ProtobufMessages.Timers.ExpireTimer _expire = _timer.getExpire();
            InternalFactHandle factHandle = inCtx.handles.get(_expire.getHandleId());
            EntryPointNode epn = ((ReteooRuleBase)inCtx.wm.getRuleBase()).getRete().getEntryPointNode(new EntryPoint(_expire.getEntryPointId()));
            Class<?> cls = ((ReteooRuleBase)inCtx.wm.getRuleBase()).getRootClassLoader().loadClass(_expire.getClassName());
            ObjectTypeNode otn = epn.getObjectTypeNodes().get(new ClassObjectType(cls));
            TimerService clock = inCtx.wm.getTimerService();
            ExpireJobContext jobctx = new ExpireJobContext(new ReteooWorkingMemory.WorkingMemoryReteExpireAction(factHandle, otn), inCtx.wm);
            JobHandle handle = clock.scheduleJob(job, jobctx, new PointInTimeTrigger(_expire.getNextFireTimestamp(), null, null));
            jobctx.setJobHandle(handle);
        }
    }

    public static class ExpireJobContextTimerOutputMarshaller
    implements TimersOutputMarshaller {
        @Override
        public void write(JobContext jobCtx, MarshallerWriteContext outputCtx) throws IOException {
            outputCtx.writeShort(54);
            ExpireJobContext ejobCtx = (ExpireJobContext)jobCtx;
            ReteooWorkingMemory.WorkingMemoryReteExpireAction expireAction = ejobCtx.getExpireAction();
            outputCtx.writeInt(expireAction.getFactHandle().getId());
            outputCtx.writeUTF(expireAction.getNode().getEntryPoint().getEntryPointId());
            outputCtx.writeUTF(((ClassObjectType)expireAction.getNode().getObjectType()).getClassType().getName());
            DefaultJobHandle jobHandle = (DefaultJobHandle)ejobCtx.getJobHandle();
            PointInTimeTrigger trigger = (PointInTimeTrigger)jobHandle.getTimerJobInstance().getTrigger();
            outputCtx.writeLong(trigger.hasNextFireTime().getTime());
        }

        @Override
        public ProtobufMessages.Timers.Timer serialize(JobContext jobCtx, MarshallerWriteContext outputCtx) {
            ExpireJobContext ejobCtx = (ExpireJobContext)jobCtx;
            ReteooWorkingMemory.WorkingMemoryReteExpireAction expireAction = ejobCtx.getExpireAction();
            DefaultJobHandle jobHandle = (DefaultJobHandle)ejobCtx.getJobHandle();
            PointInTimeTrigger trigger = (PointInTimeTrigger)jobHandle.getTimerJobInstance().getTrigger();
            return ProtobufMessages.Timers.Timer.newBuilder().setType(ProtobufMessages.Timers.TimerType.EXPIRE).setExpire(ProtobufMessages.Timers.ExpireTimer.newBuilder().setHandleId(expireAction.getFactHandle().getId()).setEntryPointId(expireAction.getNode().getEntryPoint().getEntryPointId()).setClassName(((ClassObjectType)expireAction.getNode().getObjectType()).getClassType().getName()).setNextFireTimestamp(trigger.hasNextFireTime().getTime()).build()).build();
        }
    }

    public static class ExpireJobContext
    implements JobContext,
    Externalizable {
        public ReteooWorkingMemory.WorkingMemoryReteExpireAction expireAction;
        public InternalWorkingMemory workingMemory;
        public JobHandle handle;

        public ExpireJobContext(ReteooWorkingMemory.WorkingMemoryReteExpireAction expireAction, InternalWorkingMemory workingMemory) {
            this.expireAction = expireAction;
            this.workingMemory = workingMemory;
        }

        @Override
        public JobHandle getJobHandle() {
            return this.handle;
        }

        @Override
        public void setJobHandle(JobHandle jobHandle) {
            this.handle = jobHandle;
        }

        public ReteooWorkingMemory.WorkingMemoryReteExpireAction getExpireAction() {
            return this.expireAction;
        }

        public void setExpireAction(ReteooWorkingMemory.WorkingMemoryReteExpireAction expireAction) {
            this.expireAction = expireAction;
        }

        public InternalWorkingMemory getWorkingMemory() {
            return this.workingMemory;
        }

        public void setWorkingMemory(InternalWorkingMemory workingMemory) {
            this.workingMemory = workingMemory;
        }

        public JobHandle getHandle() {
            return this.handle;
        }

        public void setHandle(JobHandle handle) {
            this.handle = handle;
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
        }
    }

    public static class ExpireJob
    implements Job {
        @Override
        public void execute(JobContext ctx) {
            ExpireJobContext context = (ExpireJobContext)ctx;
            context.workingMemory.queueWorkingMemoryAction(context.expireAction);
        }
    }

    public static class Id {
        private final Class<?> clazz;
        private final int id;

        public Id(Class<?> clazz, int id) {
            this.clazz = clazz;
            this.id = id;
        }

        public String toString() {
            return "ObjectTypeNode.Id[" + this.clazz.getName() + "#" + this.id + "]";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof Id)) {
                return false;
            }
            Id otherId = (Id)o;
            return this.id == otherId.id && this.clazz == otherId.clazz;
        }

        public int hashCode() {
            int result = this.clazz.hashCode();
            result = 31 * result + this.id;
            return result;
        }

        public boolean before(Id otherId) {
            return otherId != null && this.clazz == otherId.clazz && this.id < otherId.id;
        }

        public Class<?> getTypeNodeClass() {
            return this.clazz;
        }

        public int getId() {
            return this.id;
        }
    }

    private static class IdGenerator {
        private final Class<?> otnClass;
        private int otnIdCounter;

        private IdGenerator(ObjectType objectType) {
            this.otnClass = objectType instanceof ClassObjectType ? ((ClassObjectType)objectType).getClassType() : Object.class;
        }

        private Id nextId() {
            return new Id(this.otnClass, this.otnIdCounter++);
        }

        private void reset() {
            this.otnIdCounter = 0;
        }
    }
}

