/*
 * Decompiled with CFR 0.152.
 */
package org.kie.internal.utils;

import java.io.InputStream;
import org.kie.api.KieBase;
import org.kie.api.KieServices;
import org.kie.api.builder.KieBuilder;
import org.kie.api.builder.KieFileSystem;
import org.kie.api.builder.Message;
import org.kie.api.builder.Results;
import org.kie.api.io.Resource;
import org.kie.api.io.ResourceType;

public class KieHelper {
    public final KieServices ks = KieServices.Factory.get();
    public final KieFileSystem kfs = this.ks.newKieFileSystem();
    private int counter = 0;

    public KieBase build() {
        KieBuilder kieBuilder = this.ks.newKieBuilder(this.kfs).buildAll();
        Results results = kieBuilder.getResults();
        if (results.hasMessages(new Message.Level[]{Message.Level.ERROR})) {
            throw new RuntimeException(results.getMessages().toString());
        }
        return this.ks.newKieContainer(this.ks.getRepository().getDefaultReleaseId()).getKieBase();
    }

    public KieHelper addContent(String content, ResourceType type) {
        this.kfs.write(this.generateResourceName(type), content);
        return this;
    }

    public KieHelper addFromClassPath(String name) {
        return this.addFromClassPath(name, null);
    }

    public KieHelper addFromClassPath(String name, String encoding) {
        InputStream input = this.getClass().getResourceAsStream(name);
        if (input == null) {
            throw new IllegalArgumentException("The file (" + name + ") does not exist as a classpath resource.");
        }
        ResourceType type = ResourceType.determineResourceType((String)name);
        this.kfs.write(this.generateResourceName(type), this.ks.getResources().newInputStreamResource(input, encoding));
        return this;
    }

    public KieHelper addResource(Resource resource) {
        this.kfs.write(resource);
        return this;
    }

    public KieHelper addResource(Resource resource, ResourceType type) {
        if (resource.getSourcePath() == null && resource.getTargetPath() == null) {
            resource.setSourcePath(this.generateResourceName(type));
        }
        return this.addResource(resource);
    }

    private String generateResourceName(ResourceType type) {
        return "src/main/resources/file" + this.counter++ + "." + type.getDefaultExtension();
    }
}

