/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.kie.services.impl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.SimpleAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;
import org.jbpm.kie.services.impl.model.NodeInstanceDesc;

public class SearchServiceImpl {
    private IndexWriter iw = null;
    private IndexSearcher is = null;

    public SearchServiceImpl() {
        try {
            SimpleAnalyzer analyzer = new SimpleAnalyzer(Version.LUCENE_40);
            this.iw = new IndexWriter((Directory)FSDirectory.open((File)new File("index/")), new IndexWriterConfig(Version.LUCENE_40, (Analyzer)analyzer));
        }
        catch (IOException ex) {
            Logger.getLogger(SearchServiceImpl.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public void index(NodeInstanceDesc node) throws IOException {
        Document d = new Document();
        d.add((IndexableField)new StringField("processName", node.getName(), Field.Store.YES));
        d.add((IndexableField)new StringField("nodeId", String.valueOf(node.getNodeId()), Field.Store.YES));
        d.add((IndexableField)new StringField("processInstanceId", String.valueOf(node.getProcessInstanceId()), Field.Store.YES));
        d.add((IndexableField)new StringField("sessionId", String.valueOf(node.getDeploymentId()), Field.Store.YES));
        d.add((IndexableField)new StringField("all", String.valueOf(node.getDeploymentId()), Field.Store.NO));
        d.add((IndexableField)new StringField("all", String.valueOf(node.getProcessInstanceId()), Field.Store.NO));
        d.add((IndexableField)new StringField("all", String.valueOf(node.getNodeId()), Field.Store.NO));
        d.add((IndexableField)new StringField("all", String.valueOf(node.getName()), Field.Store.NO));
        d.add((IndexableField)new StringField("suggest", node.getName(), Field.Store.NO));
        this.iw.updateDocument(new Term("processName"), (Iterable)d);
        DirectoryReader ireader = DirectoryReader.open((IndexWriter)this.iw, (boolean)true);
        this.is = new IndexSearcher((IndexReader)ireader);
    }

    public void commit() throws IOException {
        this.iw.commit();
    }

    public List<Map<String, String>> search(String query, int nroOfResults) throws ParseException, IOException {
        SimpleAnalyzer analyzer = new SimpleAnalyzer(Version.LUCENE_40);
        QueryParser parser = new QueryParser(Version.LUCENE_40, "all", (Analyzer)analyzer);
        TopDocs search = this.is.search(parser.parse(query), nroOfResults);
        ArrayList<Map<String, String>> docs = new ArrayList<Map<String, String>>(search.scoreDocs.length);
        for (ScoreDoc d : search.scoreDocs) {
            Document doc = this.is.doc(d.doc);
            HashMap<String, String> myDoc = new HashMap<String, String>();
            for (IndexableField f : doc) {
                myDoc.put(f.name(), f.stringValue());
            }
            docs.add(myDoc);
        }
        return docs;
    }
}

